/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning.GameShow;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.TutorController;
import edu.cmu.pact.miss.PeerLearning.GameShow.Competitor;
import edu.cmu.pact.miss.PeerLearning.GameShow.Contestant;
import edu.cmu.pact.miss.PeerLearning.GameShow.DummyContestantV2;
import edu.cmu.pact.miss.PeerLearning.GameShow.GameShowWrapper;
import edu.cmu.pact.miss.PeerLearning.GameShow.ProblemBankTableModel;
import edu.cmu.pact.miss.PeerLearning.SimStPLE;
import edu.cmu.pact.miss.PeerLearning.StudentAvatarDisplay;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class GameShowPlatform
extends JComponent {
    private static final long serialVersionUID = 1L;
    BR_Controller brController = null;
    boolean runningAsApplication = false;
    Contestant contestant = null;
    JComponent studentInterface = null;
    Dimension platformSize = null;
    JLabel simStAvatorIcon = null;
    StudentAvatarDisplay simStAvatar = null;
    JLabel matchupAvatarIcon = null;
    StudentAvatarDisplay matchupAvatar = null;
    final int simStAvatorIconWidth = 200;
    final int simStAvatorIconHeight = 200;
    Dimension simStAvatorIconSize = new Dimension(200, 200);
    static Font labelFont = new Font("SansSerif", 1, 14);
    static Font chatFont = new Font("Monospaced", 0, 11);
    JLabel simStNameLabel = null;
    JLabel matchupNameLabel = null;
    JFrame topLevelFrame;
    Dimension windowSize = new Dimension(800, 900);
    Dimension examplePanelSize = new Dimension(500, 400);
    JDesktopPane desktop;
    JPanel gamePanel;
    JPanel matchupPanel;
    JPanel reviewPanel;
    JPanel topPanel;
    private JFrame problemInputDialog;
    JTextField lhsInput;
    JTextField rhsInput;
    JButton problemInputOk;
    JButton problemBankButton;
    private boolean setToClose = false;
    JLabel ratingLabel;
    JLabel oppRatingLabel;
    JLabel statsLabel;
    JLabel oppStatsLabel;
    JLabel oppName;
    JLabel oppAvatarImage;
    JList participantList;
    StudentAvatarDisplay oppAvatarImg;
    JButton randomContest;
    JButton challengeContest;
    JLabel groupChat;
    JTextField groupInput;
    JScrollPane chatScroll;
    JLabel commentLabel;
    JLabel leaderboard;
    JButton leaderButton;
    JLabel hostSpeech;
    JLabel problem;
    JLabel hostImage;
    JLabel contImage;
    JLabel oppImage;
    JLabel contLabel;
    JLabel oppLabel;
    JLabel contAnswer;
    JLabel oppAnswer;
    JLabel contScore;
    JLabel oppScore;
    JLabel chat;
    JTextField input;
    JScrollPane privateChatScroll;
    StudentAvatarDisplay contSimStAvatar;
    StudentAvatarDisplay contOppAvatar;
    JButton continueButton;
    JLabel reviewHost;
    JLabel reviewHostSpeech;
    JTabbedPane reviewTabs;
    JLabel reviewContImgOverall;
    JLabel reviewContNameOverall;
    JLabel reviewOppImgOverall;
    JLabel reviewOppNameOverall;
    JLabel reviewContOverall;
    JLabel reviewOppOverall;
    JLabel[] reviewContName;
    JLabel[] reviewContImg;
    JLabel[] reviewOppName;
    JLabel[] reviewOppImg;
    JLabel[] reviewCont;
    JLabel[] reviewOpp;
    JLabel[] reviewContCorrect;
    JLabel[] reviewOppCorrect;
    StudentAvatarDisplay reviewContAvatarOverall;
    StudentAvatarDisplay reviewOppAvatarOverall;
    StudentAvatarDisplay[] reviewContAvatar;
    StudentAvatarDisplay[] reviewOppAvatar;
    public static String NOT_ATTEMPED = "Problem Not Attempted";
    JFrame problemBankFrame;
    JTable problemBankTable;

    public Dimension getExamplePanelSize() {
        return this.examplePanelSize;
    }

    public GameShowPlatform(JComponent tutorPanel, TutorController brController) {
        BR_Controller temp = (BR_Controller)brController;
        this.setBrController(temp);
        Dimension tutorPanelPreferredSize = tutorPanel.getPreferredSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        trace.out("miss", "screenSize = " + screenSize);
        int width = tutorPanelPreferredSize.width * 2 + 100;
        this.setPlatformSize(new Dimension(width, screenSize.height));
        this.setPreferredSize(this.getPlatformSize());
        trace.out("miss", "platformSize = " + this.getPlatformSize());
        this.setLayout(new BoxLayout(this, 1));
        this.setStudentInterface(tutorPanel);
        SimStPLE.setComponentFont(tutorPanel, labelFont);
        int tpWidth = this.getPlatformSize().width;
        int tpHeight = this.getPlatformSize().height;
        this.topPanel = new JPanel();
        this.examplePanelSize = new Dimension(tpWidth, tpHeight);
        this.topPanel.setPreferredSize(this.getExamplePanelSize());
        this.topPanel.setLayout(new FlowLayout());
        this.setupMatchupPanel();
        this.setupGameshowPanel(tutorPanel);
        this.setupReviewPanel();
        this.topPanel.add(this.matchupPanel);
        this.topPanel.add(this.gamePanel);
        this.topPanel.add(this.reviewPanel);
        if (this.getBrController().getMissController().getSimSt().isDummyContestResponse()) {
            this.setContestant(new DummyContestantV2(temp, this));
        } else {
            this.setContestant(new Contestant(temp, this));
        }
        this.randomContest.addActionListener(this.getContestant());
        this.challengeContest.addActionListener(this.getContestant());
        this.challengeContest.setEnabled(false);
        this.continueButton.addActionListener(this.getContestant());
        this.participantList.addListSelectionListener(this.getContestant());
        this.participantList.setCellRenderer(this.getContestant().new Contestant.ParticipantListCellRenderer());
        this.input.addActionListener(this.getContestant());
        this.groupInput.addActionListener(this.getContestant());
        this.reviewTabs.addChangeListener(this.getContestant());
        this.leaderButton.addActionListener(this.getContestant());
        this.topPanel.getInputMap(2).put(KeyStroke.getKeyStroke("ctrl R"), "reconnect");
        this.topPanel.getActionMap().put("reconnect", this.getContestant().getReconnectAction());
        this.add(this.topPanel);
        this.topPanel.add(new JLabel());
        this.requestFocus();
        this.viewMatchup();
    }

    public void showProblemInputDialog() {
        int seconds = 60;
        GridBagConstraints cPrompt = new GridBagConstraints();
        cPrompt.gridx = 0;
        cPrompt.gridy = 0;
        cPrompt.fill = 1;
        cPrompt.weighty = 0.3;
        cPrompt.weightx = 1.0;
        cPrompt.insets = new Insets(0, 5, 0, 5);
        GridBagConstraints cEquation = new GridBagConstraints();
        cEquation.gridx = 0;
        cEquation.gridy = 1;
        cEquation.fill = 2;
        cEquation.weighty = 0.2;
        cEquation.weightx = 1.0;
        cEquation.insets = new Insets(0, 5, 0, 5);
        GridBagConstraints cButton = new GridBagConstraints();
        cButton.gridx = 0;
        cButton.gridy = 2;
        cButton.fill = 0;
        cButton.weighty = 0.4;
        cButton.weightx = 1.0;
        GridBagConstraints cButton2 = new GridBagConstraints();
        cButton2.gridx = 0;
        cButton2.gridy = 3;
        cButton2.fill = 0;
        cButton2.weighty = 0.4;
        cButton2.weightx = 1.0;
        this.problemInputDialog = new JFrame("Please Provide the Next Problem");
        this.problemInputDialog.setSize(new Dimension(350, 200));
        this.problemInputDialog.setLocationRelativeTo(this.studentInterface);
        this.problemInputDialog.setAlwaysOnTop(true);
        this.problemInputDialog.setVisible(true);
        this.problemInputDialog.getContentPane().setLayout(new GridBagLayout());
        this.problemInputDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GameShowPlatform.this.getContestant().actionPerformed(new ActionEvent(GameShowPlatform.this.problemInputDialog.getWindowListeners()[0], 0, "WindowClosed"));
            }
        });
        JPanel equation = new JPanel();
        equation.setLayout(new BoxLayout(equation, 0));
        this.lhsInput = new JTextField();
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.lhsInput);
        this.rhsInput = new JTextField();
        jTextUndoPacket = JUndo.makeTextUndoable(this.rhsInput);
        JLabel eq = new JLabel(" = ");
        this.lhsInput.setFont(labelFont);
        this.rhsInput.setFont(labelFont);
        eq.setFont(labelFont);
        equation.add(this.lhsInput);
        equation.add(eq);
        equation.add(this.rhsInput);
        JLabel prompt = new JLabel("<html>Please Provide the Next Problem.<br> You have " + seconds + " seconds to respond.</html>");
        prompt.setFont(labelFont);
        this.problemInputOk = new JButton("OK");
        this.problemInputOk.setActionCommand("ProblemInputSubmit");
        this.problemInputOk.addActionListener(this.getContestant());
        this.problemInputDialog.getContentPane().add((Component)prompt, cPrompt);
        this.problemInputDialog.getContentPane().add((Component)equation, cEquation);
        this.problemInputDialog.getContentPane().add((Component)this.problemInputOk, cButton);
        this.problemBankButton = new JButton("Generate Potential Problems");
        this.problemBankButton.setActionCommand("ProblemBankButton");
        this.problemBankButton.addActionListener(this.getContestant());
        this.problemInputDialog.getContentPane().add((Component)this.problemBankButton, cButton2);
        this.problemInputDialog.validate();
        Timer timer = new Timer(this.problemInputDialog, prompt);
    }

    public void closeProblemInputDialog() {
        if (this.problemInputDialog != null) {
            this.problemInputDialog.setVisible(false);
        }
    }

    void initApplicationGUI(JComponent studentInterface) {
        this.setRunningAsApplication(true);
        this.setTopLevelFrame(new JFrame());
        this.getTopLevelFrame().getContentPane().add(studentInterface);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.setToClose) {
            Container parent;
            this.setToClose = true;
            for (parent = this.getParent(); parent != null && !(parent instanceof GameShowWrapper); parent = parent.getParent()) {
            }
            if (parent != null) {
                ((GameShowWrapper)parent).setContestant(this.getContestant());
            }
        }
    }

    private void setupMatchupPanel() {
        this.matchupPanel = new JPanel();
        JPanel mainPanel = new JPanel();
        JPanel avatarPanel = new JPanel();
        JPanel listPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        JPanel myAvatarPanel = new JPanel();
        JPanel oppAvatarPanel = new JPanel();
        JPanel myAvImagePanel = new JPanel();
        JPanel oppAvImagePanel = new JPanel();
        JPanel myRatingPanel = new JPanel();
        JPanel oppRatingPanel = new JPanel();
        JPanel commentPanel = new JPanel();
        JPanel leaderPanel = new JPanel();
        this.matchupPanel.setLayout(new BoxLayout(this.matchupPanel, 0));
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        avatarPanel.setLayout(new BoxLayout(avatarPanel, 0));
        listPanel.setLayout(new BoxLayout(listPanel, 0));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        myAvatarPanel.setLayout(new BoxLayout(myAvatarPanel, 0));
        oppAvatarPanel.setLayout(new BoxLayout(oppAvatarPanel, 0));
        myAvImagePanel.setLayout(new BoxLayout(myAvImagePanel, 1));
        oppAvImagePanel.setLayout(new BoxLayout(oppAvImagePanel, 1));
        myRatingPanel.setLayout(new BoxLayout(myRatingPanel, 1));
        oppRatingPanel.setLayout(new BoxLayout(oppRatingPanel, 1));
        commentPanel.setLayout(new BoxLayout(commentPanel, 0));
        leaderPanel.setLayout(new BoxLayout(leaderPanel, 1));
        myRatingPanel.setBorder(BorderFactory.createEtchedBorder());
        oppRatingPanel.setBorder(BorderFactory.createEtchedBorder());
        commentPanel.setBorder(BorderFactory.createEtchedBorder());
        mainPanel.add(avatarPanel);
        mainPanel.add(commentPanel);
        mainPanel.add(listPanel);
        this.matchupPanel.add(mainPanel);
        this.matchupPanel.add(leaderPanel);
        avatarPanel.add(myAvatarPanel);
        avatarPanel.add(oppAvatarPanel);
        this.participantList = new JList();
        this.participantList.setFont(chatFont);
        listPanel.add(this.participantList);
        listPanel.add(buttonPanel);
        myAvatarPanel.add(myAvImagePanel);
        this.ratingLabel = new JLabel();
        this.ratingLabel.setFont(labelFont);
        this.statsLabel = new JLabel();
        myAvatarPanel.add(myRatingPanel);
        myRatingPanel.add(this.ratingLabel);
        myRatingPanel.add(this.statsLabel);
        this.matchupAvatarIcon = new JLabel(new ImageIcon(SimStPLE.STUDENT_IMAGE));
        this.matchupAvatar = new StudentAvatarDisplay(SimStPLE.STUDENT_IMAGE);
        myAvImagePanel.add(this.matchupAvatar);
        this.matchupNameLabel = new JLabel();
        this.matchupNameLabel.setFont(labelFont);
        myAvImagePanel.add(this.matchupNameLabel);
        this.oppRatingLabel = new JLabel();
        this.oppRatingLabel.setFont(labelFont);
        this.oppStatsLabel = new JLabel();
        oppAvatarPanel.add(oppRatingPanel);
        oppRatingPanel.add(this.oppRatingLabel);
        oppRatingPanel.add(this.oppStatsLabel);
        oppAvatarPanel.add(oppAvImagePanel);
        this.oppAvatarImage = new JLabel();
        this.oppAvatarImg = new StudentAvatarDisplay();
        this.oppAvatarImg.clearImage();
        oppAvImagePanel.add(this.oppAvatarImg);
        this.oppName = new JLabel();
        this.oppName.setFont(labelFont);
        oppAvImagePanel.add(this.oppName);
        this.commentLabel = new JLabel();
        this.commentLabel.setFont(chatFont);
        commentPanel.add(this.commentLabel);
        this.challengeContest = new JButton("Challenge Selected Student");
        this.challengeContest.setActionCommand("ContestChallengeButton");
        buttonPanel.add(this.challengeContest);
        this.randomContest = new JButton("Enter Random Game Show");
        this.randomContest.setActionCommand("ContestRequestButton");
        JPanel chatPanel = new JPanel();
        chatPanel.setLayout(new GridBagLayout());
        chatPanel.setPreferredSize(new Dimension(425, 175));
        mainPanel.add(chatPanel);
        GridBagConstraints cChat = new GridBagConstraints();
        cChat.gridx = 0;
        cChat.gridy = 0;
        cChat.fill = 1;
        cChat.weighty = 0.9;
        cChat.weightx = 1.0;
        cChat.anchor = 23;
        GridBagConstraints cInput = new GridBagConstraints();
        cInput.gridx = 0;
        cInput.gridy = 1;
        cInput.fill = 1;
        cInput.weighty = 0.1;
        cInput.weightx = 1.0;
        this.groupChat = new JLabel();
        this.groupChat.setText("<html>");
        this.groupChat.setBackground(Color.white);
        this.groupChat.setVerticalAlignment(1);
        this.groupChat.setFont(chatFont);
        this.chatScroll = new JScrollPane(this.groupChat);
        this.chatScroll.setBackground(Color.white);
        this.chatScroll.setHorizontalScrollBarPolicy(31);
        this.groupInput = new JTextField();
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.groupInput);
        this.groupInput.setFont(chatFont);
        this.groupInput.setActionCommand("GroupInputField");
        chatPanel.add((Component)this.chatScroll, cChat);
        chatPanel.add((Component)this.groupInput, cInput);
        this.leaderboard = new JLabel();
        this.leaderboard.setFont(chatFont);
        this.leaderboard.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        leaderPanel.add(this.leaderboard);
        this.leaderButton = new JButton("Refresh Leaderboard");
        this.leaderButton.setActionCommand("LeaderboardButton");
        leaderPanel.add(this.leaderButton);
        leaderPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
    }

    private void setupGameshowPanel(JComponent tutorPanel) {
        this.gamePanel = new JPanel();
        this.gamePanel.setLayout(new GridBagLayout());
        GridBagConstraints cHost = new GridBagConstraints();
        cHost.gridx = 0;
        cHost.gridy = 0;
        cHost.gridwidth = 1;
        GridBagConstraints cCont = new GridBagConstraints();
        cCont.gridx = 1;
        cCont.gridy = 0;
        cCont.gridwidth = 2;
        GridBagConstraints cWork = new GridBagConstraints();
        cWork.gridx = 3;
        cWork.gridy = 0;
        cWork.gridwidth = 3;
        JPanel hostPanel = new JPanel();
        JPanel contestantPanel = new JPanel();
        JPanel workPanel = new JPanel();
        hostPanel.setLayout(new BoxLayout(hostPanel, 1));
        contestantPanel.setLayout(new BoxLayout(contestantPanel, 1));
        workPanel.setLayout(new BoxLayout(workPanel, 1));
        this.gamePanel.add((Component)hostPanel, cHost);
        this.gamePanel.add((Component)contestantPanel, cCont);
        this.gamePanel.add((Component)workPanel, cWork);
        this.hostSpeech = new JLabel("Welcome to the Contest!");
        this.hostSpeech.setFont(labelFont);
        this.hostSpeech.setSize(new Dimension(200, 200));
        this.hostSpeech.setBorder(BorderFactory.createEtchedBorder());
        this.hostImage = new JLabel(this.createImageIcon("img/host.png"));
        hostPanel.add(this.hostSpeech);
        hostPanel.add(this.hostImage);
        this.problem = new JLabel();
        this.problem.setFont(labelFont);
        this.problem.setSize(new Dimension(400, 100));
        this.problem.setBorder(BorderFactory.createEtchedBorder());
        JPanel contsPanel = new JPanel();
        contsPanel.setLayout(new BoxLayout(contsPanel, 0));
        JPanel chatPanel = new JPanel();
        chatPanel.setLayout(new GridBagLayout());
        chatPanel.setPreferredSize(new Dimension(325, 175));
        contestantPanel.add(this.problem);
        contestantPanel.add(contsPanel);
        contestantPanel.add(chatPanel);
        GridBagConstraints cChat = new GridBagConstraints();
        cChat.gridx = 0;
        cChat.gridy = 0;
        cChat.fill = 1;
        cChat.weighty = 0.9;
        cChat.weightx = 1.0;
        GridBagConstraints cInput = new GridBagConstraints();
        cInput.gridx = 0;
        cInput.gridy = 1;
        cInput.fill = 1;
        cInput.weighty = 0.1;
        cInput.weightx = 1.0;
        this.chat = new JLabel();
        this.chat.setText("<html>");
        this.chat.setBackground(Color.white);
        this.chat.setVerticalAlignment(1);
        this.chat.setFont(chatFont);
        this.privateChatScroll = new JScrollPane(this.chat);
        this.privateChatScroll.setHorizontalScrollBarPolicy(31);
        this.input = new JTextField();
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.input);
        this.input.setFont(chatFont);
        this.input.setActionCommand("InputField");
        chatPanel.add((Component)this.privateChatScroll, cChat);
        chatPanel.add((Component)this.input, cInput);
        JPanel conts1Panel = new JPanel();
        conts1Panel.setLayout(new BoxLayout(conts1Panel, 1));
        JPanel conts2Panel = new JPanel();
        conts2Panel.setLayout(new BoxLayout(conts2Panel, 1));
        contsPanel.add(conts1Panel);
        contsPanel.add(conts2Panel);
        JPanel contLabelPanel = new JPanel();
        JPanel oppLabelPanel = new JPanel();
        this.contImage = new JLabel(new ImageIcon(SimStPLE.STUDENT_IMAGE));
        this.contSimStAvatar = new StudentAvatarDisplay(SimStPLE.STUDENT_IMAGE);
        this.oppImage = new JLabel(new ImageIcon(SimStPLE.STUDENT_IMAGE));
        this.contOppAvatar = new StudentAvatarDisplay(SimStPLE.STUDENT_IMAGE);
        this.contAnswer = new JLabel();
        this.contAnswer.setFont(labelFont);
        this.contAnswer.setMinimumSize(new Dimension(50, 30));
        this.contAnswer.setBorder(BorderFactory.createEtchedBorder());
        this.contAnswer.setSize(new Dimension(100, 50));
        this.oppAnswer = new JLabel();
        this.oppAnswer.setFont(labelFont);
        this.oppAnswer.setMinimumSize(new Dimension(50, 30));
        this.oppAnswer.setBorder(BorderFactory.createEtchedBorder());
        this.oppAnswer.setSize(new Dimension(100, 50));
        conts1Panel.add(this.contSimStAvatar);
        conts1Panel.add(contLabelPanel);
        conts1Panel.add(this.contAnswer);
        conts2Panel.add(this.contOppAvatar);
        conts2Panel.add(oppLabelPanel);
        conts2Panel.add(this.oppAnswer);
        this.contLabel = new JLabel();
        this.contScore = new JLabel();
        contLabelPanel.add(this.contLabel);
        contLabelPanel.add(this.contScore);
        this.oppLabel = new JLabel();
        this.oppScore = new JLabel();
        oppLabelPanel.add(this.oppLabel);
        oppLabelPanel.add(this.oppScore);
        this.simStAvatorIcon = new JLabel();
        this.simStAvatorIcon.setFont(labelFont);
        workPanel.add(this.simStAvatorIcon);
        SimStPLE.setComponentEnabled(false, tutorPanel);
        workPanel.add(tutorPanel);
        this.simStNameLabel = new JLabel();
    }

    private void setupReviewPanel() {
        this.reviewPanel = new JPanel();
        this.gamePanel.setLayout(new GridBagLayout());
        GridBagConstraints cHost = new GridBagConstraints();
        cHost.gridx = 0;
        cHost.gridy = 0;
        cHost.gridwidth = 2;
        GridBagConstraints cCont = new GridBagConstraints();
        cCont.gridx = 2;
        cCont.gridy = 0;
        cCont.gridwidth = 6;
        cCont.fill = 1;
        JPanel hostPanel = new JPanel();
        this.reviewPanel.add((Component)hostPanel, cHost);
        hostPanel.setLayout(new BoxLayout(hostPanel, 1));
        this.reviewHostSpeech = new JLabel("Welcome to the Contest!");
        this.reviewHostSpeech.setFont(labelFont);
        this.reviewHostSpeech.setSize(new Dimension(200, 200));
        this.reviewHostSpeech.setBorder(BorderFactory.createEtchedBorder());
        this.reviewHost = new JLabel(this.createImageIcon("img/host.png"));
        hostPanel.add(this.reviewHostSpeech);
        hostPanel.add(this.reviewHost);
        this.reviewTabs = new JTabbedPane();
        this.reviewTabs.setMinimumSize(new Dimension(800, 400));
        this.reviewContName = new JLabel[5];
        this.reviewContImg = new JLabel[5];
        this.reviewContAvatar = new StudentAvatarDisplay[5];
        this.reviewOppName = new JLabel[5];
        this.reviewOppImg = new JLabel[5];
        this.reviewOppAvatar = new StudentAvatarDisplay[5];
        this.reviewCont = new JLabel[5];
        this.reviewOpp = new JLabel[5];
        this.reviewContCorrect = new JLabel[5];
        this.reviewOppCorrect = new JLabel[5];
        JPanel overallTab = new JPanel();
        overallTab.setPreferredSize(new Dimension(700, 300));
        overallTab.setLayout(new GridLayout(1, 2));
        this.reviewTabs.addTab("Overall", overallTab);
        this.reviewPanel.add((Component)this.reviewTabs, cCont);
        GridBagConstraints cAvatar = new GridBagConstraints();
        cAvatar.gridx = 0;
        cAvatar.gridy = 0;
        cAvatar.gridwidth = 1;
        cAvatar.gridheight = 1;
        cAvatar.weighty = 0.3;
        cAvatar.fill = 2;
        cAvatar.anchor = 18;
        GridBagConstraints cDetails = new GridBagConstraints();
        cDetails.gridx = 0;
        cDetails.gridy = 1;
        cDetails.gridwidth = 1;
        cDetails.gridheight = 3;
        cDetails.weighty = 0.9;
        cDetails.fill = 1;
        cDetails.anchor = 18;
        GridBagConstraints cPaper = new GridBagConstraints();
        cPaper.gridx = 0;
        cPaper.gridy = 1;
        cPaper.gridwidth = 1;
        cPaper.gridheight = 4;
        JPanel contOverall = new JPanel();
        contOverall.setBorder(BorderFactory.createEtchedBorder());
        contOverall.setLayout(new GridBagLayout());
        overallTab.add(contOverall);
        JPanel oppOverall = new JPanel();
        oppOverall.setBorder(BorderFactory.createEtchedBorder());
        oppOverall.setLayout(new GridBagLayout());
        overallTab.add(oppOverall);
        JPanel contOverallNameImg = new JPanel();
        contOverallNameImg.setLayout(new BoxLayout(contOverallNameImg, 0));
        contOverall.add((Component)contOverallNameImg, cAvatar);
        this.reviewContImgOverall = new JLabel();
        this.reviewContAvatarOverall = new StudentAvatarDisplay();
        this.reviewContNameOverall = new JLabel();
        this.reviewContNameOverall.setFont(labelFont);
        contOverallNameImg.add(this.reviewContAvatarOverall);
        contOverallNameImg.add(this.reviewContNameOverall);
        this.reviewContOverall = new JLabel();
        this.reviewContOverall.setFont(labelFont);
        contOverall.add((Component)this.reviewContOverall, cDetails);
        JPanel oppOverallNameImg = new JPanel();
        oppOverallNameImg.setLayout(new BoxLayout(oppOverallNameImg, 0));
        oppOverall.add((Component)oppOverallNameImg, cAvatar);
        this.reviewOppImgOverall = new JLabel();
        this.reviewOppAvatarOverall = new StudentAvatarDisplay();
        this.reviewOppNameOverall = new JLabel();
        this.reviewOppNameOverall.setFont(labelFont);
        oppOverallNameImg.add(this.reviewOppAvatarOverall);
        oppOverallNameImg.add(this.reviewOppNameOverall);
        this.reviewOppOverall = new JLabel();
        this.reviewOppOverall.setFont(labelFont);
        oppOverall.add((Component)this.reviewOppOverall, cDetails);
        for (int i = 0; i < 5; ++i) {
            this.setUpReviewPane(i);
        }
        this.continueButton = new JButton("Continue");
        this.continueButton.setActionCommand("ReviewContinueButton");
        hostPanel.add(this.continueButton);
    }

    public JPanel setUpReviewPane(int number) {
        GridBagConstraints cAvatar = new GridBagConstraints();
        cAvatar.gridx = 0;
        cAvatar.gridy = 0;
        cAvatar.gridwidth = 1;
        cAvatar.gridheight = 1;
        cAvatar.weighty = 0.3;
        cAvatar.fill = 2;
        cAvatar.anchor = 18;
        GridBagConstraints cDetails = new GridBagConstraints();
        cDetails.gridx = 0;
        cDetails.gridy = 1;
        cDetails.gridwidth = 1;
        cDetails.gridheight = 3;
        cDetails.weighty = 0.9;
        cDetails.fill = 1;
        cDetails.anchor = 18;
        GridBagConstraints cCheck = new GridBagConstraints();
        cCheck.gridx = 0;
        cCheck.gridy = 4;
        cCheck.gridwidth = 1;
        cCheck.gridheight = 1;
        cCheck.weighty = 0.2;
        cCheck.anchor = 20;
        JPanel tab = new JPanel();
        tab.setPreferredSize(new Dimension(700, 300));
        tab.setLayout(new GridLayout(1, 2));
        this.reviewTabs.addTab("Problem #" + (number + 1), tab);
        JPanel cont = new JPanel();
        cont.setBorder(BorderFactory.createEtchedBorder());
        cont.setLayout(new GridBagLayout());
        tab.add(cont);
        JPanel opp = new JPanel();
        opp.setBorder(BorderFactory.createEtchedBorder());
        opp.setLayout(new GridBagLayout());
        tab.add(opp);
        JPanel contNameImg = new JPanel();
        contNameImg.setLayout(new BoxLayout(contNameImg, 0));
        cont.add((Component)contNameImg, cAvatar);
        this.reviewContImg[number] = new JLabel();
        this.reviewContAvatar[number] = new StudentAvatarDisplay();
        this.reviewContName[number] = new JLabel();
        this.reviewContName[number].setFont(labelFont);
        contNameImg.add(this.reviewContAvatar[number]);
        contNameImg.add(this.reviewContName[number]);
        this.reviewCont[number] = new JLabel();
        this.reviewCont[number].setFont(labelFont);
        cont.add((Component)this.reviewCont[number], cDetails);
        JPanel oppNameImg = new JPanel();
        oppNameImg.setLayout(new BoxLayout(oppNameImg, 0));
        opp.add((Component)oppNameImg, cAvatar);
        this.reviewOppImg[number] = new JLabel();
        this.reviewOppAvatar[number] = new StudentAvatarDisplay();
        this.reviewOppName[number] = new JLabel();
        this.reviewOppName[number].setFont(labelFont);
        oppNameImg.add(this.reviewOppAvatar[number]);
        oppNameImg.add(this.reviewOppName[number]);
        this.reviewOpp[number] = new JLabel();
        this.reviewOpp[number].setFont(labelFont);
        opp.add((Component)this.reviewOpp[number], cDetails);
        this.reviewContCorrect[number] = new JLabel(new ImageIcon("true.png"));
        cont.add((Component)this.reviewContCorrect[number], cCheck);
        this.reviewOppCorrect[number] = new JLabel(new ImageIcon("true.png"));
        opp.add((Component)this.reviewOppCorrect[number], cCheck);
        return tab;
    }

    public void viewMatchup() {
        this.gamePanel.setVisible(false);
        this.matchupPanel.setVisible(true);
        this.reviewPanel.setVisible(false);
    }

    public void viewGameshow() {
        this.participantList.clearSelection();
        this.gamePanel.setVisible(true);
        this.matchupPanel.setVisible(false);
        this.reviewPanel.setVisible(false);
    }

    public void viewReview() {
        this.gamePanel.setVisible(false);
        this.matchupPanel.setVisible(false);
        this.reviewPanel.setVisible(true);
        this.reviewTabs.setSelectedIndex(0);
    }

    public boolean isRunningAsApplication() {
        return this.runningAsApplication;
    }

    public void setRunningAsApplication(boolean runningAsApplication) {
        this.runningAsApplication = runningAsApplication;
    }

    public BR_Controller getBrController() {
        return this.brController;
    }

    public void setBrController(BR_Controller brController) {
        this.brController = brController;
    }

    public Contestant getContestant() {
        return this.contestant;
    }

    public void setContestant(Contestant contest) {
        this.contestant = contest;
    }

    public JComponent getStudentInterface() {
        return this.studentInterface;
    }

    public void setStudentInterface(JComponent studentInterface) {
        this.studentInterface = studentInterface;
    }

    public void setParticipantList(Object[] names) {
        this.participantList.setListData(names);
    }

    public Competitor getSelectedParticipant() {
        return (Competitor)this.participantList.getSelectedValue();
    }

    public JFrame getTopLevelFrame() {
        return this.topLevelFrame;
    }

    public void setTopLevelFrame(JFrame topLevelFrame) {
        this.topLevelFrame = topLevelFrame;
    }

    public void setImage(String img) {
        ImageIcon newImg = new ImageIcon(img);
        Image thumbnail = newImg.getImage().getScaledInstance(86, -1, 1);
        this.contImage.setIcon(newImg);
        this.contSimStAvatar.setImage(img);
        this.matchupAvatar.setImage(img);
        this.reviewContImgOverall.setIcon(new ImageIcon(thumbnail));
        this.reviewContAvatarOverall.setImage(img);
        for (int i = 0; i < this.reviewContImg.length; ++i) {
            this.reviewContImg[i].setIcon(new ImageIcon(thumbnail));
            this.reviewContAvatar[i].setImage(img);
        }
    }

    public void setGameShowExpression(String express) {
        this.contSimStAvatar.setExpression(express);
    }

    public void setOppGameShowExpression(String express) {
        this.contOppAvatar.setExpression(express);
    }

    public void setReviewExpression(String express) {
        this.reviewContAvatarOverall.setExpression(express);
        for (int i = 0; i < this.reviewContImg.length; ++i) {
            this.reviewContAvatar[i].setExpression(express);
        }
    }

    public void setOppReviewExpression(String express) {
        this.reviewOppAvatarOverall.setExpression(express);
        for (int i = 0; i < this.reviewContImg.length; ++i) {
            this.reviewOppAvatar[i].setExpression(express);
        }
    }

    public void setOpponent(Competitor comp) {
        if (comp == null) {
            ImageIcon newImg = new ImageIcon();
            this.contOppAvatar.clearImage();
            this.oppName.setText("");
            this.oppLabel.setText("");
            this.oppRatingLabel.setText("");
            this.oppAvatarImage.setIcon(newImg);
            this.oppAvatarImg.clearImage();
            this.oppStatsLabel.setText("");
            this.reviewOppNameOverall.setText("");
            return;
        }
        ImageIcon newImg = new ImageIcon(comp.img);
        this.oppImage.setIcon(newImg);
        this.contOppAvatar.setImage(comp.img);
        this.oppName.setText(comp.name);
        this.oppLabel.setText(comp.name);
        this.oppRatingLabel.setText("  " + comp.rating);
        this.oppAvatarImage.setIcon(newImg);
        this.oppAvatarImg.setImage(comp.img);
        this.oppStatsLabel.setText("<html>Wins: " + comp.wins + "<br>Losses: " + comp.losses + "<br>Ties: " + comp.ties + "</html>");
        this.reviewOppNameOverall.setText(comp.name);
        if (comp.img != null) {
            Image thumbnail = newImg.getImage().getScaledInstance(86, -1, 1);
            this.reviewOppImgOverall.setIcon(new ImageIcon(thumbnail));
            this.reviewOppAvatarOverall.setImage(comp.img);
            for (int i = 0; i < this.reviewOppImg.length; ++i) {
                this.reviewOppImg[i].setIcon(new ImageIcon(thumbnail));
                this.reviewOppAvatar[i].setImage(comp.img);
                this.reviewOppName[i].setText(comp.name);
            }
        }
    }

    @Override
    public void setName(String name) {
        this.matchupNameLabel.setText(name);
        this.contLabel.setText(name);
        this.reviewContNameOverall.setText(name);
        this.simStAvatorIcon.setText(name + "'s Worksheet");
        for (int i = 0; i < this.reviewContName.length; ++i) {
            this.reviewContName[i].setText(name);
        }
    }

    public void setRating(int rating) {
        this.ratingLabel.setText(rating + "  ");
    }

    public void setRating(Competitor comp) {
        this.ratingLabel.setText(comp.rating + "  ");
        this.statsLabel.setText("<html>Wins: " + comp.wins + "<br>Losses: " + comp.losses + "<br>Ties: " + comp.ties + "</html>");
    }

    public void enableChallengeButton(boolean enable) {
        this.challengeContest.setEnabled(enable);
    }

    public void colorOpponentRating(Color color) {
        this.oppRatingLabel.setForeground(color);
    }

    public void setAnswer(String answer) {
        this.contAnswer.setText(answer);
    }

    public void setOppAnswer(String answer) {
        this.oppAnswer.setText(answer);
    }

    public void clearAnswers() {
        this.contAnswer.setText("");
        this.oppAnswer.setText("");
        this.contAnswer.setForeground(Color.black);
        this.oppAnswer.setForeground(Color.black);
    }

    public void setCorrectness(boolean cont, boolean opp) {
        if (cont) {
            this.contAnswer.setForeground(Color.green.darker());
        } else {
            this.contAnswer.setForeground(Color.red);
        }
        if (opp) {
            this.oppAnswer.setForeground(Color.green.darker());
        } else {
            this.oppAnswer.setForeground(Color.red);
        }
    }

    public void setScores(int cont, int opp) {
        this.contScore.setText("" + cont);
        this.oppScore.setText("" + opp);
    }

    public void setSolutions(String[] cont, String[] opp, String[] contCorr, String[] oppCorr) {
        int i;
        for (i = 0; i < cont.length; ++i) {
            this.reviewCont[i].setText(cont[i]);
        }
        for (i = cont.length; i < this.reviewCont.length; ++i) {
            this.reviewCont[i].setText(NOT_ATTEMPED);
        }
        for (i = 0; i < opp.length; ++i) {
            this.reviewOpp[i].setText(opp[i]);
        }
        for (i = opp.length; i < this.reviewOpp.length; ++i) {
            this.reviewOpp[i].setText(NOT_ATTEMPED);
        }
        for (i = 0; i < contCorr.length; ++i) {
            this.reviewContCorrect[i].setIcon(new ImageIcon(contCorr[i] + ".png"));
        }
        for (i = contCorr.length; i < this.reviewContCorrect.length; ++i) {
            this.reviewContCorrect[i].setIcon(new ImageIcon("noattempt.png"));
        }
        for (i = 0; i < oppCorr.length; ++i) {
            this.reviewOppCorrect[i].setIcon(new ImageIcon(oppCorr[i] + ".png"));
        }
        for (i = oppCorr.length; i < this.reviewOppCorrect.length; ++i) {
            this.reviewOppCorrect[i].setIcon(new ImageIcon("noattempt.png"));
        }
    }

    public void setRatings(String cont, String opp) {
        this.reviewContOverall.setText(cont);
        this.reviewOppOverall.setText(opp);
    }

    public void setHostSpeech(String text) {
        this.hostSpeech.setText(text);
        this.reviewHostSpeech.setText(text);
    }

    public void setProblem(String text) {
        this.problem.setText(text);
    }

    public JLabel getSimStAvatorIcon() {
        return this.simStAvatorIcon;
    }

    public void setSimStAvatorIcon(JLabel simStAvatorIcon) {
        this.simStAvatorIcon = simStAvatorIcon;
    }

    public Dimension getPlatformSize() {
        return this.platformSize;
    }

    public void setPlatformSize(Dimension plaformSize) {
        this.platformSize = plaformSize;
    }

    public void addPrivateChatText(String text) {
        this.chat.setText(this.chat.getText() + GameShowPlatform.getWrappedText(text, 300, "black"));
        this.scrollPaneToBottom();
    }

    public void addPrivateAnnounceText(String text) {
        this.chat.setText(this.chat.getText() + GameShowPlatform.getWrappedText(text, 300, "blue"));
        this.scrollPaneToBottom();
    }

    public void addPrivateNotification(String text) {
        this.chat.setText(this.chat.getText() + GameShowPlatform.getWrappedText(text, 300, "red"));
        this.scrollPaneToBottom();
    }

    public void clearPrivateChat() {
        this.chat.setText("<html>");
    }

    public void addGroupChatText(String text) {
        this.groupChat.setText(this.groupChat.getText() + GameShowPlatform.getWrappedText(text, 420, "black"));
        this.scrollPaneToBottom();
    }

    public void addGroupAnnounceText(String text) {
        this.groupChat.setText(this.groupChat.getText() + GameShowPlatform.getWrappedText(text, 420, "blue"));
        this.scrollPaneToBottom();
    }

    public void addGroupNotification(String text) {
        this.groupChat.setText(this.groupChat.getText() + GameShowPlatform.getWrappedText(text, 420, "red"));
        this.scrollPaneToBottom();
    }

    public String takeInput() {
        String inputString = this.input.getText();
        this.input.setText("");
        return inputString;
    }

    public String getLhsInput() {
        return this.lhsInput.getText();
    }

    public String getRhsInput() {
        return this.rhsInput.getText();
    }

    public String takeGroupInput() {
        String inputString = this.groupInput.getText();
        this.groupInput.setText("");
        return inputString;
    }

    public void scrollPaneToBottom() {
        if (SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GameShowPlatform.this.chatScroll.getVerticalScrollBar().setValue(GameShowPlatform.this.chatScroll.getVerticalScrollBar().getMaximum());
                    GameShowPlatform.this.privateChatScroll.getVerticalScrollBar().setValue(GameShowPlatform.this.privateChatScroll.getVerticalScrollBar().getMaximum());
                }
            });
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        GameShowPlatform.this.chatScroll.getVerticalScrollBar().setValue(GameShowPlatform.this.chatScroll.getVerticalScrollBar().getMaximum());
                        GameShowPlatform.this.privateChatScroll.getVerticalScrollBar().setValue(GameShowPlatform.this.privateChatScroll.getVerticalScrollBar().getMaximum());
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String getWrappedText(String text, int width, String color) {
        Calendar cal = Calendar.getInstance();
        String now = cal.get(12) < 10 ? "[" + cal.get(10) + ":0" + cal.get(12) + "]" : "[" + cal.get(10) + ":" + cal.get(12) + "]";
        if (now.contains("[0:")) {
            now = now.replace("[0:", "[12:");
        }
        text = now + " " + text;
        JLabel temp = new JLabel(text);
        temp.setFont(chatFont);
        int textWidth = temp.getPreferredSize().width;
        if (textWidth > width && width != 0) {
            double percentFits = (double)width / (double)textWidth;
            int charsFit = (int)(percentFits * (double)text.length());
            String remaining = text;
            String formatted = "<font color=" + color + ">";
            while (remaining.length() > 0) {
                int newLine;
                if (remaining.length() < charsFit) {
                    int newLine2 = remaining.indexOf("\\n");
                    String tempString = "";
                    if (newLine2 != -1) {
                        tempString = remaining.substring(0, newLine2);
                        formatted = formatted + tempString + "<br>";
                        remaining = remaining.substring(newLine2 + 2);
                    }
                    formatted = formatted + remaining + "<br>";
                    remaining = "";
                    continue;
                }
                int firstSpace = remaining.indexOf(32);
                if (firstSpace == -1) {
                    firstSpace = remaining.length();
                }
                if ((newLine = remaining.indexOf("\\n")) == -1) {
                    newLine = remaining.length();
                }
                String tempString = "";
                if (newLine < charsFit) {
                    tempString = remaining.substring(0, newLine);
                    remaining = remaining.substring(newLine + 2);
                } else if (firstSpace > charsFit) {
                    tempString = remaining.substring(0, firstSpace);
                    remaining = firstSpace + 1 >= remaining.length() ? "" : remaining.substring(firstSpace + 1);
                } else {
                    tempString = remaining.substring(0, charsFit);
                    int lastSpace = tempString.lastIndexOf(32);
                    remaining = remaining.substring(lastSpace + 1);
                    tempString = tempString.substring(0, lastSpace);
                }
                formatted = formatted + tempString + "<br>";
            }
            formatted = formatted + "</font>";
            return formatted;
        }
        return "<font color=" + color + ">" + text + "<br></font>";
    }

    protected ImageIcon createImageIcon(String path) {
        String file = "/edu/cmu/pact/miss/PeerLearning/" + path;
        URL url = this.getClass().getResource(file);
        return new ImageIcon(url);
    }

    public void displayProblemBank(String[] columns, Object[][] problemBank) {
        if (this.problemBankFrame != null && this.problemBankFrame.isEnabled()) {
            this.problemBankFrame.dispose();
        }
        this.problemBankFrame = new JFrame("Bank of Problems");
        this.problemBankFrame.setVisible(true);
        final String[] columnToolTips = new String[]{"Generated Problems to Try Solving", "Number of Times Students Tried Problems Similar to This One", "Estimated Difficulty of the Problem"};
        this.problemBankTable = new JTable(new ProblemBankTableModel(columns, problemBank)){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                return columnToolTips[realIndex];
            }
        };
        this.problemBankTable.setFillsViewportHeight(true);
        JScrollPane scroll = new JScrollPane(this.problemBankTable);
        this.problemBankFrame.getContentPane().add(scroll);
        this.problemBankFrame.setSize(400, 400);
        this.problemBankTable.setSize(400, 400);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.problemBankTable.getModel());
        this.problemBankTable.setRowSorter(sorter);
    }

    public static void main(String[] args) {
    }

    public void setMatchupComment(String comment) {
        this.commentLabel.setText(comment);
    }

    public void setLeaderboard(String leaderboardText) {
        this.leaderboard.setText(leaderboardText);
    }

    class Timer
    implements Runnable {
        private JFrame frame;
        private JLabel promptLabel;
        private Thread thread = null;
        private int seconds = 60;
        private final int min = 0;

        public Timer(JFrame frame, JLabel prompt) {
            this.frame = frame;
            this.promptLabel = prompt;
            this.thread = new Thread(this);
            this.thread.start();
        }

        @Override
        public void run() {
            while (this.seconds > 0) {
                --this.seconds;
                this.promptLabel.setText("<html>Please Provide the Next Problem:<br>(You have " + this.seconds + " seconds to respond.)</html>");
                try {
                    Thread.sleep(850L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

