/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning;

import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.miss.PeerLearning.SimStPLE;
import edu.cmu.pact.miss.PeerLearning.StudentAvatarDesigner;
import edu.cmu.pact.miss.SimSt;
import edu.cmu.pact.miss.storage.StorageClient;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MasterAvatarDesigner
extends StudentAvatarDesigner
implements DocumentListener {
    private static final long serialVersionUID = 1L;
    protected JTextField userID;
    protected JButton load;
    protected JLabel status;
    protected boolean webRetrieve = false;
    protected boolean webConnect = true;

    @Override
    public void setup() {
        this.setLayout(new BoxLayout(this, 3));
        this.add(Box.createRigidArea(new Dimension(10, 10)));
        this.createOptionPanel();
        this.add(this.getOptionPanel());
        this.randomize();
        this.createLayeredImage();
        this.add(Box.createRigidArea(new Dimension(10, 10)));
        JPanel avatarPanel = new JPanel();
        avatarPanel.setLayout(new BoxLayout(avatarPanel, 0));
        avatarPanel.add(Box.createRigidArea(new Dimension(30, 10)));
        avatarPanel.add(this.getLayeredImage());
        this.random = new JButton("Randomize");
        avatarPanel.add(this.random);
        this.random.addActionListener(this);
        avatarPanel.add(Box.createRigidArea(new Dimension(70, 10)));
        this.add(avatarPanel);
        this.createButtonPanel();
        this.add(this.getButtonPanel());
        this.add(Box.createRigidArea(new Dimension(100, 10)));
        this.status = new JLabel("Program Started");
        this.add(this.status);
        this.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        frame.setPreferredSize(new Dimension(350, 360));
        frame.setLocation(50, 50);
    }

    @Override
    protected void createButtonPanel() {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 3));
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BoxLayout(namePanel, 0));
        JLabel nameLabel = new JLabel(" Student Name: ");
        this.buttonPanel.add(namePanel);
        namePanel.add(nameLabel);
        this.name = new JTextField();
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.name);
        this.name.getDocument().addDocumentListener(this);
        namePanel.add(this.name);
        JPanel saveLoadPanel = new JPanel();
        saveLoadPanel.setLayout(new BoxLayout(saveLoadPanel, 0));
        JLabel userIDLabel = new JLabel(" User ID: ");
        saveLoadPanel.add(userIDLabel);
        this.userID = new JTextField();
        JUndo.JTextUndoPacket jTextUndoPacket2 = JUndo.makeTextUndoable(this.userID);
        saveLoadPanel.add(this.userID);
        this.userID.getDocument().addDocumentListener(this);
        this.load = new JButton("Load");
        saveLoadPanel.add(this.load);
        this.load.addActionListener(this);
        this.save = new JButton("Save");
        saveLoadPanel.add(this.save);
        this.save.addActionListener(this);
        this.buttonPanel.add(saveLoadPanel);
    }

    protected static void createAndShowGUI() {
        if (frame == null) {
            frame = new JFrame("Customize Your Student");
            frame.setDefaultCloseOperation(3);
        }
        MasterAvatarDesigner newContentPane = new MasterAvatarDesigner();
        newContentPane.setOpaque(true);
        frame.getContentPane().add(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.save) {
            String saveString = "%";
            saveString = saveString + this.silhouettes[this.backgroundIndex] + "%";
            saveString = saveString + this.hairdos[this.hairIndex] + "%";
            SimStPLE.STUDENT_IMAGE = saveString = saveString + this.shirts[this.shirtIndex];
            if (this.name.getText().length() > 0) {
                SimSt.setSimStName(this.name.getText());
            }
            this.accountName = this.userID.getText();
            if (this.webConnect) {
                SimSt.WEBSTARTENABLED = true;
                this.status.setText("Saved Account " + this.accountName + " to Web");
            } else {
                SimSt.WEBSTARTENABLED = false;
                this.status.setText("Saved Account " + this.accountName + " to Local File");
            }
            SimStPLE.saveAccountFile(this.accountName + ".account");
            this.setBorder(BorderFactory.createLineBorder(Color.black, 1));
            return;
        }
        if (arg0.getSource() == this.load) {
            this.loadAccountInfo();
            this.setBorder(BorderFactory.createLineBorder(Color.black, 1));
            return;
        }
        this.setBorder(BorderFactory.createLineBorder(Color.yellow, 1));
        if (!this.status.getText().endsWith("*")) {
            this.status.setText(this.status.getText() + " *");
        }
        super.actionPerformed(arg0);
    }

    public void loadAccountInfo() {
        String user = this.userID.getText();
        String accountInfo = user + ".account";
        boolean successful = false;
        this.webRetrieve = false;
        try {
            this.webRetrieve = new StorageClient().retrieveFile(user + ".account", accountInfo, ".");
            this.webConnect = true;
        }
        catch (IOException e1) {
            e1.printStackTrace();
            this.webConnect = false;
        }
        File accountFile = null;
        accountFile = new File(accountInfo);
        if (accountFile != null && accountFile.exists()) {
            successful = true;
            try {
                String imgName;
                BufferedReader read = new BufferedReader(new FileReader(accountFile));
                String charName = read.readLine();
                this.name.setText(charName);
                SimSt.setSimStName(charName);
                SimStPLE.STUDENT_IMAGE = imgName = read.readLine();
                this.setImage(imgName);
                String tmp = read.readLine();
                if (tmp != null && tmp.length() > 0) {
                    SimStPLE.currentOverallProblem = Integer.parseInt(tmp);
                }
                read.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!successful) {
            this.status.setText(" Account " + user + " Not Found");
        } else if (this.webRetrieve) {
            this.status.setText("Loaded Account " + user + " from Web");
        } else {
            this.status.setText("Loaded Account " + user + " from Local File");
        }
    }

    public void setImage(String img) {
        int i;
        String[] imgParts = img.split("%");
        for (i = 0; i < this.silhouettes.length; ++i) {
            if (!imgParts[1].equals(this.silhouettes[i])) continue;
            this.backgroundIndex = i;
        }
        for (i = 0; i < this.hairdos.length; ++i) {
            if (!imgParts[2].equals(this.hairdos[i])) continue;
            this.hairIndex = i;
        }
        for (i = 0; i < this.shirts.length; ++i) {
            if (!imgParts[5].equals(this.shirts[i])) continue;
            this.shirtIndex = i;
        }
        ImageIcon icon = this.createImageIcon(this.silhouettes[this.backgroundIndex]);
        ImageIcon icon2 = this.createImageIcon(this.hairdos[this.hairIndex]);
        ImageIcon icon5 = this.createImageIcon(this.shirts[this.shirtIndex]);
        ImageIcon icon6 = this.createImageIcon(this.faces[this.faceIndex]);
        this.backgroundLabel.setIcon(icon);
        this.hairLabel.setIcon(icon2);
        this.shirtLabel.setIcon(icon5);
        this.faceLabel.setIcon(icon6);
    }

    public static void main(String[] args) {
        MasterAvatarDesigner.createAndShowGUI();
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
        this.setBorder(BorderFactory.createLineBorder(Color.yellow, 1));
        if (!this.status.getText().endsWith("*")) {
            this.status.setText(this.status.getText() + " *");
        }
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        this.setBorder(BorderFactory.createLineBorder(Color.yellow, 1));
        if (!this.status.getText().endsWith("*")) {
            this.status.setText(this.status.getText() + " *");
        }
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        this.setBorder(BorderFactory.createLineBorder(Color.yellow, 1));
        if (!this.status.getText().endsWith("*")) {
            this.status.setText(this.status.getText() + " *");
        }
    }
}

