/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.FeaturePredicate;
import edu.cmu.pact.miss.FoilData;
import edu.cmu.pact.miss.HashMap;
import java.io.Serializable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import mylib.CombinatoricException;
import mylib.Permutations;

public class Relation
implements Serializable {
    private static final long serialVersionUID = 5883203199327368417L;
    private FeaturePredicate predicate;
    private HashMap featurePredicateHash;
    private String name;
    private boolean targetRelation = false;
    private int arity;
    private int inputArity;
    private String key;
    private Vector positiveTuples = new Vector();
    private Vector negativeTuples = new Vector();
    public static final int NO_NULL = 1;
    transient Vector instructions = new Vector();
    private int[] targetArgType = null;

    FeaturePredicate getPredicate() {
        return this.predicate;
    }

    private void setPredicate(FeaturePredicate predicate) {
        this.predicate = predicate;
    }

    private void setFeaturePredicateHash(HashMap featurePredicateHash) {
        this.featurePredicateHash = featurePredicateHash;
    }

    private FeaturePredicate getFeaturePredicate(String name) {
        return (FeaturePredicate)this.featurePredicateHash.get(name);
    }

    private void putFeaturePredicate(String name, FeaturePredicate fp) {
        this.featurePredicateHash.put(name, fp);
    }

    String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    private boolean isTargetRelation() {
        return this.targetRelation;
    }

    private void setTargetRelation(boolean flag) {
        this.targetRelation = flag;
    }

    int getArity() {
        return this.arity;
    }

    private void setArity(int arity) {
        this.arity = arity;
    }

    int getInputArity() {
        return this.inputArity;
    }

    private void setInputArity(String key) {
        this.inputArity = 0;
        for (int i = 0; i < key.length(); ++i) {
            if (key.charAt(i) != '#') continue;
            ++this.inputArity;
        }
    }

    String getKey() {
        return this.key;
    }

    private void setKey(String key) {
        this.key = key;
    }

    Vector getPositiveTuples() {
        return this.positiveTuples;
    }

    void addPositiveTuple(Vector tuple) {
        if (this.isValidTupleType(tuple)) {
            if (!this.alreadyIn(this.getPositiveTuples(), tuple)) {
                this.positiveTuples.add(tuple);
            }
            if (this.alreadyIn(this.getNegativeTuples(), tuple)) {
                if (trace.getDebugCode("miss")) {
                    trace.out("miss", tuple + "'s been claimed as a positive tuple.");
                }
                this.getNegativeTuples().remove(tuple);
            }
        }
    }

    public Vector getNegativeTuples() {
        return this.negativeTuples;
    }

    private Vector getNegativeTuples(int mode) {
        switch (mode) {
            case 1: {
                return this.getNegativeTuplesNoNull();
            }
        }
        return null;
    }

    private Vector getNegativeTuplesNoNull() {
        Vector<Vector> negativeTuples = new Vector<Vector>();
        Vector allNegativeTuples = this.getNegativeTuples();
        for (int i = 0; i < allNegativeTuples.size(); ++i) {
            Vector tuple = (Vector)allNegativeTuples.get(i);
            if (tuple.contains(null)) continue;
            negativeTuples.add(tuple);
        }
        return negativeTuples;
    }

    void addNegativeTuple(Vector tuple) {
        if (this.isValidTupleType(tuple) && !tuple.contains(null) && !this.alreadyIn(this.getPositiveTuples(), tuple) && !this.alreadyIn(this.getNegativeTuples(), tuple)) {
            this.getNegativeTuples().add(tuple);
        }
    }

    void addExplicitNegativeTuple(Vector tuple) {
        if (this.isValidTupleType(tuple)) {
            if (!this.alreadyIn(this.getNegativeTuples(), tuple)) {
                this.negativeTuples.add(tuple);
            }
            if (this.alreadyIn(this.getPositiveTuples(), tuple)) {
                if (trace.getDebugCode("miss")) {
                    trace.out("miss", tuple + "'s been claimed as a negative tuple.");
                }
                this.getPositiveTuples().remove(tuple);
            }
        }
    }

    boolean alreadyIn(Vector vv, Vector v) {
        boolean test = false;
        for (int i = 0; i < vv.size(); ++i) {
            Vector v0 = (Vector)vv.get(i);
            if (!v0.equals(v)) continue;
            test = true;
            break;
        }
        return test;
    }

    private Vector getAllTuples() {
        Vector allTuples = new Vector();
        allTuples.addAll(this.getPositiveTuples());
        allTuples.addAll(this.getNegativeTuples());
        return allTuples;
    }

    int numAllTuples() {
        return this.getPositiveTuples().size() + this.getNegativeTuples().size();
    }

    int numPosTuples() {
        return this.getPositiveTuples().size();
    }

    int numNegTuples() {
        return this.getNegativeTuples().size();
    }

    boolean hasTuples() {
        return this.numAllTuples() != 0;
    }

    boolean hasTuples(int mode) {
        switch (mode) {
            case 1: {
                return this.hasTuplesNoNull();
            }
        }
        return false;
    }

    boolean hasTuplesNoNull() {
        boolean hasTuplesNoNull = !this.getPositiveTuples().isEmpty() || !this.getNegativeTuples(1).isEmpty();
        return hasTuplesNoNull;
    }

    public int getTargetArgType(int i) {
        return this.targetArgType[i];
    }

    private void initTargetArgType() {
        this.targetArgType = new int[this.getArity()];
    }

    private void setTargetArgType(int i, int type) {
        this.targetArgType[i] = type;
    }

    void setTargetArgType(Vector focusOfAttention) {
        this.initTargetArgType();
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "Inside setTargetArgType:" + focusOfAttention.size());
        }
        for (int i = 1; i < focusOfAttention.size(); ++i) {
            String foa = (String)focusOfAttention.get(i);
            String foaValue = foa.split("\\|")[2];
            this.setTargetArgType(i - 1, FeaturePredicate.valueType(foaValue));
        }
    }

    public int getArgType(int n) {
        int argTypeID = -1;
        FeaturePredicate predicate = this.getPredicate();
        argTypeID = predicate != null ? predicate.getArgValueType(n) : this.getTargetArgType(n);
        return argTypeID;
    }

    private boolean isValidTupleType(Vector args) {
        boolean isValidArgument = true;
        for (int i = 0; i < args.size(); ++i) {
            if (FeaturePredicate.valueType((String)args.get(i)) == this.getArgType(i)) continue;
            isValidArgument = false;
            break;
        }
        return isValidArgument;
    }

    public Relation(String predicateDef, HashMap featurePredicateHash) {
        int leftParenIndex = predicateDef.indexOf(40);
        String className = predicateDef.substring(0, leftParenIndex);
        String keyStr = predicateDef.substring(leftParenIndex + 1, predicateDef.length() - 1);
        int dotIndex = className.lastIndexOf(46);
        String name = dotIndex == -1 ? className : className.substring(dotIndex + 1, className.length());
        String theKey = "";
        StringTokenizer keys = new StringTokenizer(keyStr, ", ");
        while (keys.hasMoreElements()) {
            theKey = theKey + keys.nextToken();
        }
        this.setName(name);
        this.setKey(theKey);
        this.setArity(theKey.length());
        this.setInputArity(theKey);
        this.setFeaturePredicateHash(featurePredicateHash);
        FeaturePredicate predicate = this.getFeaturePredicate(className);
        if (predicate == null) {
            predicate = FeaturePredicate.getPredicateByClassName(className);
            this.putFeaturePredicate(className, predicate);
        }
        this.setPredicate(predicate);
    }

    public Relation(String name, int arity, HashMap featurePredicateHash) {
        if (trace.getDebugCode("foasearch")) {
            trace.out("foasearch", "constructing Relation \"" + name + "\" with arity = " + arity);
        }
        String theKey = "";
        for (int i = 0; i < arity; ++i) {
            theKey = theKey + "#";
        }
        this.setFeaturePredicateHash(featurePredicateHash);
        this.setTargetRelation(true);
        this.setName(name);
        this.setKey(theKey);
        this.setArity(arity);
        this.setInputArity(theKey);
    }

    void setTuple(FeaturePredicate predicate) {
        if (predicate != null) {
            Iterator keys = predicate.applyCasheKeys();
            while (keys.hasNext()) {
                Vector args = (Vector)((Vector)keys.next()).clone();
                String value = predicate.getApplyCache(args);
                if (args.size() != this.getArity()) {
                    args.add(value);
                }
                if (value != null) {
                    this.addPositiveTuple(args);
                    continue;
                }
                this.addNegativeTuple(args);
            }
        }
    }

    Vector evalRelation(Vector values) {
        return this.getArity() > 1 ? this.testPredicate(values, this.getArity()) : this.testPredicate(values);
    }

    private Vector testPredicate(Vector values) {
        Vector<String> extValues = new Vector<String>();
        for (int i = 0; i < values.size(); ++i) {
            Vector<String> arg = new Vector<String>();
            arg.add((String)values.get(i));
            String returnValue = this.applyPredicate(arg);
            if (returnValue == null || this.getArity() == this.getInputArity()) continue;
            extValues.add(returnValue);
        }
        return extValues.isEmpty() ? null : extValues;
    }

    private Vector testPredicate(Vector values, int arity) {
        Vector<String> extValues = new Vector<String>();
        for (Vector args : Relation.permuteArgs(values, this.getArity())) {
            String returnValue = this.applyPredicate(args);
            if (returnValue == null || this.getArity() == this.getInputArity()) continue;
            extValues.add(returnValue);
        }
        return extValues.isEmpty() ? null : extValues;
    }

    public static Vector permuteArgs(Vector values, int arity) {
        Object[] vIndex = new Object[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            vIndex[i] = new Integer(i);
        }
        Permutations vc = null;
        try {
            vc = new Permutations(vIndex, arity);
        }
        catch (CombinatoricException e) {
            e.printStackTrace();
            System.err.println("Relation.permuteArgs()'s gotten a fatal problem.");
            System.err.println("values = " + values + ", arity = " + arity);
            System.err.println("exiting...");
            System.exit(0);
        }
        Vector args = new Vector();
        while (vc.hasMoreElements()) {
            Object[] indexes = (Object[])vc.nextElement();
            Vector curArgs = new Vector();
            for (int i = 0; i < arity; ++i) {
                int index = (Integer)indexes[i];
                curArgs.add(values.get(index));
            }
            args.add(curArgs);
        }
        return args;
    }

    private String applyPredicate(Vector args) {
        String value = this.getPredicate().cachedApply(args);
        return value;
    }

    Vector getTypesFor(int n) {
        Vector allTuples = this.getAllTuples();
        Vector<String> types = new Vector<String>();
        for (int i = 0; i < allTuples.size(); ++i) {
            Vector tuple = (Vector)allTuples.get(i);
            String constant = (String)tuple.get(n);
            if (types.contains(constant)) continue;
            types.add(constant);
        }
        return types;
    }

    String v2string(Vector v) {
        if (v == null) {
            return null;
        }
        String va = "";
        for (int i = 0; i < v.size(); ++i) {
            va = va + (String)v.get(i) + " ";
        }
        return va;
    }

    public String toString() {
        String relationHead = (this.isTargetRelation() ? "" : "*") + this.getName();
        relationHead = relationHead + "(";
        for (int i = 0; i < this.getArity(); ++i) {
            relationHead = relationHead + "V" + this.getArgType(i);
            if (i >= this.getArity() - 1) continue;
            relationHead = relationHead + ", ";
        }
        relationHead = relationHead + ")";
        relationHead = relationHead + " " + this.getKey() + "\n";
        int inputArity = this.getKey().indexOf(45);
        if (inputArity < 0) {
            inputArity = this.getKey().length();
        }
        String relationStr = "";
        Vector positiveTuples = this.getPositiveTuples();
        for (int i = 0; i < positiveTuples.size(); ++i) {
            Vector posTuple = (Vector)positiveTuples.get(i);
            relationStr = relationStr + this.tupleString(posTuple) + "\n";
        }
        Vector negativeTuples = this.getNegativeTuples();
        if (!negativeTuples.isEmpty()) {
            relationStr = relationStr + ";\n";
            for (int i = 0; i < negativeTuples.size(); ++i) {
                Vector negTuple = (Vector)negativeTuples.get(i);
                relationStr = relationStr + this.tupleString(negTuple) + "\n";
            }
        }
        return relationHead + relationStr + ".";
    }

    public String toString(int varNo, String varName) {
        return this.toString(varNo, varName, null);
    }

    public String toString(int varNo, String varName, Vector validArgs) {
        String relationHead = "";
        relationHead = relationHead + (this.isTargetRelation() ? "" : "*") + this.getName();
        if (0 <= varNo) {
            relationHead = relationHead + "(";
            for (int i = 0; i < this.getArity(); ++i) {
                relationHead = relationHead + varName + this.getArgType(i);
                if (i >= this.getArity() - 1) continue;
                relationHead = relationHead + ", ";
            }
            relationHead = relationHead + ")";
        }
        relationHead = relationHead + " " + this.getKey() + "\n";
        int inputArity = this.getKey().indexOf(45);
        if (inputArity < 0) {
            inputArity = this.getKey().length();
        }
        String relationStr = "";
        boolean validRelationFound = false;
        for (int i = 0; i < this.getPositiveTuples().size(); ++i) {
            Vector posTuple = (Vector)this.getPositiveTuples().get(i);
            if (validArgs != null && !this.isValidArgs(posTuple, inputArity, validArgs)) continue;
            relationStr = relationStr + this.tupleString(posTuple) + "\n";
            validRelationFound = true;
        }
        Vector negativeTuples = this.getNegativeTuples();
        if (!negativeTuples.isEmpty()) {
            relationStr = relationStr + ";\n";
            for (int i = 0; i < negativeTuples.size(); ++i) {
                Vector negTuple = (Vector)negativeTuples.get(i);
                if (validArgs != null && !this.isValidArgs(negTuple, inputArity, validArgs)) continue;
                relationStr = relationStr + this.tupleString(negTuple) + "\n";
                validRelationFound = true;
            }
        }
        return validRelationFound ? relationHead + relationStr + "." : null;
    }

    private boolean isValidArgs(Vector args, int arity, Vector validArgs) {
        boolean isValidArgs = true;
        for (int i = 0; i < arity; ++i) {
            if (validArgs.contains((String)args.get(i))) continue;
            isValidArgs = false;
            break;
        }
        return isValidArgs;
    }

    private String tupleString(Vector tuple) {
        String tupleStr = "";
        for (int i = 0; i < tuple.size(); ++i) {
            tupleStr = tupleStr + (String)tuple.get(i);
            if (i >= tuple.size() - 1) continue;
            tupleStr = tupleStr + ", ";
        }
        return this.escapeECs(tupleStr);
    }

    private String escapeECs(String nativeStr) {
        String openP = nativeStr.replaceAll("\\(", "\\\\(");
        String closeP = openP.replaceAll("\\)", "\\\\)");
        String commas = FoilData.replaceCommas(closeP);
        return commas;
    }
}

