/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.storage;

import edu.cmu.pact.miss.storage.StorageAccess;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class StorageClient
extends StorageAccess {
    String locationURL;

    public StorageClient() {
        this.locationURL = "http://latte.pslc.cs.cmu.edu:8080";
    }

    public StorageClient(String url) {
        this.locationURL = url;
    }

    @Override
    public String retrieveString(String key) throws IOException {
        InputStream input;
        String location = this.locationURL + "/Servlet/stores?cmd=retrieve&userid=" + key;
        URL servlet = new URL(location);
        URLConnection servletConnection = servlet.openConnection();
        try {
            input = servletConnection.getInputStream();
        }
        catch (FileNotFoundException e) {
            return null;
        }
        String dataString = "";
        int data = input.read();
        while (data != -1) {
            dataString = dataString + (char)data;
            data = input.read();
        }
        return dataString;
    }

    @Override
    public boolean retrieveFile(String key, String filename) throws IOException {
        FileWriter outputter;
        InputStream input;
        String location = this.locationURL + "/Servlet/stores?cmd=retrieve&userid=" + key;
        URL servlet = new URL(location);
        URLConnection servletConnection = servlet.openConnection();
        try {
            input = servletConnection.getInputStream();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        String dataString = "";
        int data = input.read();
        while (data != -1) {
            dataString = dataString + (char)data;
            data = input.read();
        }
        try {
            outputter = new FileWriter(new File(filename));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            return false;
        }
        try {
            this.writeMessage(dataString, outputter);
        }
        catch (Exception ex) {
            return false;
        }
        try {
            outputter.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean retrieveFile(String key, String filename, String pathName) throws IOException {
        FileWriter outputter;
        InputStream input;
        String location = this.locationURL + "/Servlet/stores?cmd=retrieve&userid=" + key;
        URL servlet = new URL(location);
        URLConnection servletConnection = servlet.openConnection();
        try {
            input = servletConnection.getInputStream();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        String dataString = "";
        int data = input.read();
        while (data != -1) {
            dataString = dataString + (char)data;
            data = input.read();
        }
        try {
            outputter = new FileWriter(new File(pathName + System.getProperty("file.separator") + filename));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            return false;
        }
        try {
            this.writeMessage(dataString, outputter);
        }
        catch (Exception ex) {
            return false;
        }
        try {
            outputter.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public Object retrieveObject(String key) throws IOException {
        String location = this.locationURL + "/Servlet/stores?cmd=retrieveObj&file=" + key;
        URL servlet = new URL(location);
        URLConnection servletConnection = servlet.openConnection();
        servletConnection.setUseCaches(false);
        servletConnection.setDefaultUseCaches(false);
        ObjectInputStream inputFromServlet = new ObjectInputStream(servletConnection.getInputStream());
        Object object = null;
        try {
            object = inputFromServlet.readObject();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        inputFromServlet.close();
        return object;
    }

    public static void main(String[] args) {
        StorageClient client = new StorageClient();
        try {
            ((StorageAccess)client).storeString("hey", "instructions.txt");
            System.out.println(((StorageAccess)client).retrieveFile("hey", "tmp4.txt"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void storeFile(String key, String filename) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        String fileData = this.readFile(reader);
        String location = this.locationURL + "/Servlet/stores?cmd=store&userid=" + key;
        URL servlet = new URL(location);
        URLConnection servletConnection = servlet.openConnection();
        servletConnection.setDoInput(true);
        servletConnection.setDoOutput(true);
        servletConnection.setUseCaches(false);
        servletConnection.setDefaultUseCaches(false);
        servletConnection.setRequestProperty("Content-Type", "text/ascii");
        OutputStream output = servletConnection.getOutputStream();
        PrintWriter dataWriter = new PrintWriter(output);
        dataWriter.write(fileData);
        dataWriter.flush();
        try {
            reader.close();
            dataWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        InputStream input = servletConnection.getInputStream();
        String dataString = "";
        int data = input.read();
        while (data != -1) {
            dataString = dataString + (char)data;
            data = input.read();
        }
    }

    @Override
    public void storeZIPFile(String key, String filename) throws IOException {
        ZipEntry entry;
        String location = this.locationURL + "/Servlet/stores?cmd=storeZip&file=" + key;
        URL servlet = new URL(location);
        URLConnection servletConnection = servlet.openConnection();
        servletConnection.setDoInput(true);
        servletConnection.setDoOutput(true);
        servletConnection.setUseCaches(false);
        servletConnection.setDefaultUseCaches(false);
        servletConnection.setRequestProperty("Content-Type", "application/zip");
        FileInputStream is = new FileInputStream(filename);
        ZipInputStream zis = new ZipInputStream(is);
        BufferedInputStream bis = new BufferedInputStream(zis);
        ZipOutputStream zos = new ZipOutputStream(servletConnection.getOutputStream());
        while ((entry = zis.getNextEntry()) != null) {
            int readCount;
            zos.putNextEntry(entry);
            byte[] buffer = new byte[2048];
            while ((readCount = bis.read(buffer)) > 0) {
                zos.write(buffer, 0, readCount);
            }
            zos.flush();
        }
        zos.close();
        InputStream input = servletConnection.getInputStream();
        String dataString = "";
        int data = input.read();
        while (data != -1) {
            dataString = dataString + (char)data;
            data = input.read();
        }
    }

    @Override
    public void storeObject(String key, Object object) throws IOException {
        String location = this.locationURL + "/Servlet/stores?cmd=storeObj&file=" + key;
        URL servlet = new URL(location);
        URLConnection servletConnection = servlet.openConnection();
        servletConnection.setDoInput(true);
        servletConnection.setDoOutput(true);
        servletConnection.setUseCaches(false);
        servletConnection.setDefaultUseCaches(false);
        servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
        ObjectOutputStream output = new ObjectOutputStream(servletConnection.getOutputStream());
        output.writeObject(object);
        output.flush();
        output.close();
        InputStream input = servletConnection.getInputStream();
        String dataString = "";
        int data = input.read();
        while (data != -1) {
            dataString = dataString + (char)data;
            data = input.read();
        }
        input.close();
    }

    @Override
    public void storeString(String key, String toStore) throws IOException {
        toStore = StorageClient.encode(toStore);
        String location = this.locationURL + "/Servlet/stores?cmd=store&userid=" + key + "&text=" + toStore;
        URL servlet = new URL(location);
        URLConnection servletConnection = servlet.openConnection();
        servletConnection.setDoInput(true);
        servletConnection.setDoOutput(true);
        servletConnection.setUseCaches(false);
        servletConnection.setDefaultUseCaches(false);
        servletConnection.setRequestProperty("Content-Type", "text/ascii");
        OutputStream output = servletConnection.getOutputStream();
        PrintWriter dataWriter = new PrintWriter(output);
        dataWriter.write(toStore);
        dataWriter.flush();
        dataWriter.close();
        InputStream input = servletConnection.getInputStream();
        String dataString = "";
        int data = input.read();
        while (data != -1) {
            dataString = dataString + (char)data;
            data = input.read();
        }
    }

    public static String encode(String s) throws IOException {
        try {
            if (s == null) {
                return "";
            }
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
            throw new IOException("Unexpected error in URL encoder");
        }
    }
}

