/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.userDef.algebra.expression;

import edu.cmu.pact.miss.userDef.algebra.expression.AlgExpParser;
import edu.cmu.pact.miss.userDef.algebra.expression.ComplexFraction;
import edu.cmu.pact.miss.userDef.algebra.expression.ComplexTerm;
import edu.cmu.pact.miss.userDef.algebra.expression.Constant;
import edu.cmu.pact.miss.userDef.algebra.expression.ConstantFraction;
import edu.cmu.pact.miss.userDef.algebra.expression.DoubleConst;
import edu.cmu.pact.miss.userDef.algebra.expression.ExpParseException;
import edu.cmu.pact.miss.userDef.algebra.expression.IntConst;
import edu.cmu.pact.miss.userDef.algebra.expression.Polynomial;
import edu.cmu.pact.miss.userDef.algebra.expression.SimpleTerm;
import edu.cmu.pact.miss.userDef.algebra.expression.Variable;
import java.util.Set;

public abstract class AlgExp {
    protected boolean isFraction = false;
    protected boolean isSimple = false;
    protected boolean isConstant = false;
    protected boolean isVariable = false;
    protected boolean isMonomial = false;
    protected boolean isPolynomial = false;
    protected boolean isSimpleTerm = false;
    protected boolean isTerm = false;
    protected boolean isInt = false;
    protected boolean hasVariable = false;
    protected boolean isNegative = false;
    private boolean parenBit = false;
    public static final AlgExp ONE = new IntConst("1");
    public static final AlgExp NEGONE = new IntConst("-1");
    public static final AlgExp ZERO = new IntConst("0");
    public static final AlgExp TWO = new IntConst("2");

    boolean hasParens() {
        return this.parenBit;
    }

    void setParenBit(boolean parenBit) {
        this.parenBit = parenBit;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public boolean isVariable() {
        return this.isVariable;
    }

    public boolean isFraction() {
        return this.isFraction;
    }

    public boolean isConstantFraction() {
        return this.getClass().equals(ConstantFraction.class);
    }

    public boolean isInt() {
        return this.isInt;
    }

    public boolean isNegative() {
        return this.isNegative;
    }

    public boolean hasVariable() {
        return this.hasVariable;
    }

    public boolean isSimpleTerm() {
        return this.isSimpleTerm;
    }

    public boolean isTerm() {
        return this.isTerm;
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public boolean isMonomial() {
        return this.isMonomial;
    }

    public boolean isPolynomial() {
        return this.isPolynomial;
    }

    public AlgExp commute() {
        return this;
    }

    public abstract AlgExp add(Variable var1);

    public abstract AlgExp add(ConstantFraction var1);

    public abstract AlgExp add(SimpleTerm var1);

    public abstract AlgExp add(Polynomial var1);

    public abstract AlgExp add(ComplexTerm var1);

    public abstract AlgExp add(ComplexFraction var1);

    public abstract AlgExp add(IntConst var1);

    public abstract AlgExp add(DoubleConst var1);

    public abstract AlgExp mul(Variable var1);

    public abstract AlgExp mul(ConstantFraction var1);

    public abstract AlgExp mul(SimpleTerm var1);

    public abstract AlgExp mul(Polynomial var1);

    public abstract AlgExp mul(ComplexTerm var1);

    public abstract AlgExp mul(ComplexFraction var1);

    public abstract AlgExp mul(IntConst var1);

    public abstract AlgExp mul(DoubleConst var1);

    public abstract AlgExp div(Variable var1);

    public abstract AlgExp div(ConstantFraction var1);

    public abstract AlgExp div(SimpleTerm var1);

    public abstract AlgExp div(Polynomial var1);

    public abstract AlgExp div(ComplexTerm var1);

    public abstract AlgExp div(ComplexFraction var1);

    public abstract AlgExp div(IntConst var1);

    public abstract AlgExp div(DoubleConst var1);

    public abstract AlgExp divDecimal(IntConst var1);

    public abstract boolean equals(IntConst var1);

    public abstract boolean equals(DoubleConst var1);

    public abstract boolean equals(Variable var1);

    public abstract boolean equals(ConstantFraction var1);

    public abstract boolean equals(SimpleTerm var1);

    public abstract boolean equals(Polynomial var1);

    public abstract boolean equals(ComplexTerm var1);

    public abstract boolean equals(ComplexFraction var1);

    public abstract AlgExp eval();

    public abstract AlgExp invert();

    public AlgExp add(Constant c) {
        if (c.getClass().equals(IntConst.class)) {
            return this.add((IntConst)c);
        }
        if (c.getClass().equals(DoubleConst.class)) {
            return this.add((DoubleConst)c);
        }
        if (c.getClass().equals(ConstantFraction.class)) {
            return this.add((ConstantFraction)c);
        }
        throw new RuntimeException("Unknown class in add Constant: " + c.getClass());
    }

    public AlgExp mul(Constant c) {
        if (c.getClass().equals(IntConst.class)) {
            return this.mul((IntConst)c);
        }
        if (c.getClass().equals(DoubleConst.class)) {
            return this.mul((DoubleConst)c);
        }
        if (c.getClass().equals(ConstantFraction.class)) {
            return this.mul((ConstantFraction)c);
        }
        throw new RuntimeException("Unknown class in mul Constant: " + c.getClass());
    }

    public AlgExp add(AlgExp e) {
        if (e.equals(ZERO)) {
            return this.eval();
        }
        if (e.getClass().equals(Constant.class)) {
            return this.add((Constant)e);
        }
        if (e.getClass().equals(SimpleTerm.class)) {
            return this.add((SimpleTerm)e);
        }
        if (e.getClass().equals(Variable.class)) {
            return this.add((Variable)e);
        }
        if (e.getClass().equals(ConstantFraction.class)) {
            return this.add((ConstantFraction)e);
        }
        if (e.getClass().equals(ComplexTerm.class)) {
            return this.add((ComplexTerm)e);
        }
        if (e.getClass().equals(Polynomial.class)) {
            return this.add((Polynomial)e);
        }
        if (e.getClass().equals(ComplexFraction.class)) {
            return this.add((ComplexFraction)e);
        }
        if (e.getClass().equals(IntConst.class)) {
            return this.add((IntConst)e);
        }
        if (e.getClass().equals(DoubleConst.class)) {
            return this.add((DoubleConst)e);
        }
        throw new RuntimeException("Unknown class " + e.getClass().getName() + " in add");
    }

    public AlgExp mul(AlgExp e) {
        if (e.equals(ONE)) {
            return this.eval();
        }
        if (e.equals(ZERO)) {
            return ZERO;
        }
        if (e.getClass().equals(Constant.class)) {
            return this.mul((Constant)e);
        }
        if (e.getClass().equals(SimpleTerm.class)) {
            return this.mul((SimpleTerm)e);
        }
        if (e.getClass().equals(Variable.class)) {
            return this.mul((Variable)e);
        }
        if (e.getClass().equals(ConstantFraction.class)) {
            return this.mul((ConstantFraction)e);
        }
        if (e.getClass().equals(ComplexTerm.class)) {
            return this.mul((ComplexTerm)e);
        }
        if (e.getClass().equals(Polynomial.class)) {
            return this.mul((Polynomial)e);
        }
        if (e.getClass().equals(ComplexFraction.class)) {
            return this.mul((ComplexFraction)e);
        }
        if (e.getClass().equals(IntConst.class)) {
            return this.mul((IntConst)e);
        }
        if (e.getClass().equals(DoubleConst.class)) {
            return this.mul((DoubleConst)e);
        }
        throw new RuntimeException("Unknown class " + e.getClass().getName() + " in mul");
    }

    public AlgExp divDecimal(AlgExp divident) {
        return this.isInt() && divident.isInt() ? this.divDecimal((IntConst)divident) : this.div(divident);
    }

    public AlgExp div(AlgExp e) {
        if (e.equals(ONE)) {
            return this;
        }
        if (e.getClass().equals(Constant.class)) {
            return this.div((Constant)e);
        }
        if (e.getClass().equals(SimpleTerm.class)) {
            return this.div((SimpleTerm)e);
        }
        if (e.getClass().equals(Variable.class)) {
            return this.div((Variable)e);
        }
        if (e.getClass().equals(ConstantFraction.class)) {
            return this.div((ConstantFraction)e);
        }
        if (e.getClass().equals(ComplexTerm.class)) {
            return this.div((ComplexTerm)e);
        }
        if (e.getClass().equals(Polynomial.class)) {
            return this.div((Polynomial)e);
        }
        if (e.getClass().equals(ComplexFraction.class)) {
            return this.div((ComplexFraction)e);
        }
        if (e.getClass().equals(IntConst.class)) {
            return this.div((IntConst)e);
        }
        if (e.getClass().equals(DoubleConst.class)) {
            return this.div((DoubleConst)e);
        }
        if (e.getClass().equals(IntConst.class)) {
            return this.div((IntConst)e);
        }
        if (e.getClass().equals(DoubleConst.class)) {
            return this.div((DoubleConst)e);
        }
        if (e.getClass().equals(ConstantFraction.class)) {
            return this.div((ConstantFraction)e);
        }
        throw new RuntimeException("Unknown class " + e.getClass().getName() + " in div");
    }

    public boolean equals(AlgExp e) {
        if (e.getClass().equals(Constant.class)) {
            return this.equals((Constant)e);
        }
        if (e.getClass().equals(SimpleTerm.class)) {
            return this.equals((SimpleTerm)e);
        }
        if (e.getClass().equals(Variable.class)) {
            return this.equals((Variable)e);
        }
        if (e.getClass().equals(ConstantFraction.class)) {
            return this.equals((ConstantFraction)e);
        }
        if (e.getClass().equals(ComplexTerm.class)) {
            return this.equals((ComplexTerm)e);
        }
        if (e.getClass().equals(Polynomial.class)) {
            return this.equals((Polynomial)e);
        }
        if (e.getClass().equals(ComplexFraction.class)) {
            return this.equals((ComplexFraction)e);
        }
        if (e.getClass().equals(IntConst.class)) {
            return this.equals((IntConst)e);
        }
        if (e.getClass().equals(DoubleConst.class)) {
            return this.equals((DoubleConst)e);
        }
        throw new RuntimeException("Unknown class " + e.getClass().getName() + " in equals");
    }

    public AlgExp negate() {
        return this.mul(NEGONE);
    }

    public String parseRep() {
        return this.toString();
    }

    public static AlgExp parseExp(String s) throws ExpParseException {
        return AlgExpParser.parse(s);
    }

    public static String cancelDoubleMinus(String s) {
        return AlgExpParser.cancelDoubleMinus(s);
    }

    public abstract boolean hasVariable(String var1);

    public abstract Set getAllVars();
}

