/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.userDef.algebra.expression;

import edu.cmu.pact.miss.userDef.algebra.expression.AlgExp;
import edu.cmu.pact.miss.userDef.algebra.expression.ComplexTerm;
import edu.cmu.pact.miss.userDef.algebra.expression.ConstantFraction;
import edu.cmu.pact.miss.userDef.algebra.expression.DoubleConst;
import edu.cmu.pact.miss.userDef.algebra.expression.IntConst;
import edu.cmu.pact.miss.userDef.algebra.expression.Polynomial;
import edu.cmu.pact.miss.userDef.algebra.expression.SimpleTerm;
import edu.cmu.pact.miss.userDef.algebra.expression.Variable;
import java.util.HashSet;
import java.util.Set;

public class ComplexFraction
extends AlgExp {
    AlgExp numerator;
    AlgExp denominator;

    public ComplexFraction(AlgExp e1, AlgExp e2) {
        this.isFraction = true;
        this.numerator = e1;
        this.denominator = e2;
        this.hasVariable = this.numerator.hasVariable() || this.denominator.hasVariable();
        this.isMonomial = this.numerator.isMonomial() && this.denominator.isMonomial();
        this.isNegative = this.numerator.isNegative() ^ this.denominator.isNegative();
    }

    public AlgExp getNumerator() {
        return this.numerator;
    }

    public AlgExp getDenominator() {
        return this.denominator;
    }

    @Override
    public AlgExp add(IntConst c) {
        return new Polynomial(this, c);
    }

    @Override
    public AlgExp add(DoubleConst c) {
        return new Polynomial(this, c);
    }

    @Override
    public AlgExp add(Variable v) {
        return new Polynomial(this, v);
    }

    @Override
    public AlgExp add(ConstantFraction f) {
        return new Polynomial(this, f);
    }

    @Override
    public AlgExp add(SimpleTerm t) {
        return new Polynomial(this, t);
    }

    @Override
    public AlgExp add(Polynomial e) {
        return e.add(this);
    }

    @Override
    public AlgExp add(ComplexTerm ct) {
        return new Polynomial(this, ct);
    }

    @Override
    public AlgExp add(ComplexFraction cf) {
        if (this.denominator.equals(cf.getDenominator())) {
            return new ComplexFraction(this.numerator.add(cf.getNumerator()), this.denominator);
        }
        return new Polynomial(this, cf);
    }

    @Override
    public AlgExp mul(IntConst c) {
        return new ComplexFraction(this.numerator.mul(c), this.denominator);
    }

    @Override
    public AlgExp mul(DoubleConst c) {
        return new ComplexFraction(this.numerator.mul(c), this.denominator);
    }

    @Override
    public AlgExp mul(Variable v) {
        return new ComplexFraction(this.numerator.mul(v), this.denominator);
    }

    @Override
    public AlgExp mul(ConstantFraction f) {
        return new ComplexFraction(this.numerator.mul(f.getNumerator()), this.denominator.mul(f.getDenominator()));
    }

    @Override
    public AlgExp mul(SimpleTerm t) {
        return new ComplexFraction(this.numerator.mul(t), this.denominator);
    }

    @Override
    public AlgExp mul(Polynomial e) {
        return new ComplexFraction(this.numerator.mul(e), this.denominator);
    }

    @Override
    public AlgExp mul(ComplexTerm ct) {
        return new ComplexFraction(this.numerator.mul(ct), this.denominator).eval();
    }

    @Override
    public AlgExp mul(ComplexFraction cf) {
        return new ComplexFraction(this.numerator.mul(cf.getNumerator()), this.denominator.mul(cf.getDenominator()));
    }

    @Override
    public AlgExp div(IntConst c) {
        return this.mul(c.invert());
    }

    @Override
    public AlgExp div(DoubleConst c) {
        return this.mul(c.invert());
    }

    @Override
    public AlgExp div(Variable v) {
        return this.mul(v.invert());
    }

    @Override
    public AlgExp div(ConstantFraction f) {
        return this.mul(f.invert());
    }

    @Override
    public AlgExp div(SimpleTerm t) {
        return this.mul(t.invert());
    }

    @Override
    public AlgExp div(Polynomial e) {
        return this.mul(e.invert());
    }

    @Override
    public AlgExp div(ComplexTerm ct) {
        return this.mul(ct.invert());
    }

    @Override
    public AlgExp div(ComplexFraction cf) {
        return this.mul(cf.invert());
    }

    @Override
    public AlgExp invert() {
        if (this.numerator.equals(AlgExp.ONE)) {
            return this.denominator;
        }
        return new ComplexFraction(this.denominator, this.numerator);
    }

    @Override
    public String parseRep() {
        return "(" + this.numerator + ")/(" + this.denominator + ")";
    }

    public String toString() {
        if (this.numerator.isConstant() && this.denominator.isConstant()) {
            return this.numerator + "/" + this.denominator;
        }
        String firstTermRep = !this.numerator.isPolynomial() ? this.numerator.toString() : "(" + this.numerator.toString() + ")";
        String secondTermRep = this.denominator.isSimple() && !this.denominator.isSimpleTerm() ? this.denominator.toString() : "(" + this.denominator.toString() + ")";
        return firstTermRep.concat("/").concat(secondTermRep);
    }

    @Override
    public boolean equals(IntConst c) {
        return this.denominator.equals(AlgExp.ONE) && this.numerator.equals(c);
    }

    @Override
    public boolean equals(DoubleConst c) {
        return this.denominator.equals(AlgExp.ONE) && this.numerator.equals(c);
    }

    @Override
    public boolean equals(Variable v) {
        return this.denominator.equals(AlgExp.ONE) && this.numerator.equals(v);
    }

    @Override
    public boolean equals(ConstantFraction f) {
        return this.denominator.equals(f.getDenominator()) && this.numerator.equals(f.getNumerator());
    }

    @Override
    public boolean equals(SimpleTerm t) {
        return this.denominator.equals(AlgExp.ONE) && this.numerator.equals(t);
    }

    @Override
    public boolean equals(Polynomial e) {
        return this.denominator.equals(AlgExp.ONE) && this.numerator.equals(e);
    }

    @Override
    public boolean equals(ComplexTerm ct) {
        if (this.denominator.equals(AlgExp.ONE) && this.numerator.equals(ct)) {
            return true;
        }
        return ct.equals(this);
    }

    @Override
    public boolean equals(ComplexFraction cf) {
        return this.denominator.equals(cf.getDenominator()) && this.numerator.equals(cf.getNumerator());
    }

    @Override
    public AlgExp eval() {
        return this.numerator.eval().div(this.denominator.eval());
    }

    @Override
    public AlgExp negate() {
        return new ComplexFraction(this.numerator.negate(), this.denominator);
    }

    @Override
    public boolean hasVariable(String varName) {
        return this.numerator.hasVariable(varName) || this.denominator.hasVariable(varName);
    }

    @Override
    public Set getAllVars() {
        Set denSet;
        HashSet vars = new HashSet();
        Set numSet = this.numerator.getAllVars();
        if (!numSet.isEmpty()) {
            vars.addAll(numSet);
        }
        if (!(denSet = this.denominator.getAllVars()).isEmpty()) {
            vars.addAll(denSet);
        }
        return vars;
    }

    @Override
    public AlgExp divDecimal(IntConst c) {
        new Exception().printStackTrace();
        return null;
    }
}

