/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.userDef.algebra.expression.decomposers;

import edu.cmu.pact.miss.Decomposer;
import edu.cmu.pact.miss.userDef.algebra.expression.AlgExp;
import edu.cmu.pact.miss.userDef.algebra.expression.ComplexFraction;
import edu.cmu.pact.miss.userDef.algebra.expression.ConstantFraction;
import edu.cmu.pact.miss.userDef.algebra.expression.ExpParseException;
import java.util.Vector;

public class AlgExpFractionDecomposer
extends Decomposer {
    @Override
    public Vector decompose(String foa) {
        Vector<String> decomposedElements = null;
        try {
            AlgExp exp = AlgExp.parseExp(foa);
            if (exp.isFraction()) {
                AlgExp denominator;
                AlgExp numerator;
                decomposedElements = new Vector<String>();
                if (exp.isConstant()) {
                    ConstantFraction f = (ConstantFraction)exp;
                    numerator = f.getNumerator();
                    denominator = f.getDenominator();
                } else {
                    ComplexFraction f = (ComplexFraction)exp;
                    numerator = f.getNumerator();
                    denominator = f.getDenominator();
                }
                decomposedElements.add(numerator.toString());
                decomposedElements.add(denominator.toString());
            }
        }
        catch (ExpParseException e) {
            e.printStackTrace();
        }
        return decomposedElements;
    }
}

