/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.userDef.oldpredicates;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.FeaturePredicate;
import edu.cmu.pact.miss.userDef.oldpredicates.AlgebraExp;
import edu.cmu.pact.miss.userDef.oldpredicates.AlgebraExpPoly;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import mylib.MathLib;

public abstract class EqFeaturePredicate
extends FeaturePredicate {
    private static boolean isArithmeticExpression(String exp) {
        boolean isArithmeticExpression = true;
        if (exp.indexOf(32) > -1) {
            isArithmeticExpression = false;
        }
        return isArithmeticExpression;
    }

    public static String coefficient(String term) {
        if (!EqFeaturePredicate.isArithmeticExpression(term)) {
            return null;
        }
        String coefficient = null;
        try {
            AlgebraExp exp = AlgebraExp.parseExp(term);
            if (exp.isVarTerm()) {
                coefficient = exp.getCoefficient();
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return coefficient;
    }

    public String coefficient_obsolete(String term) {
        String coefficient = null;
        if (term.indexOf(47) == -1 && this.monomial(term) != null && this.varTerm(term) != null) {
            coefficient = term.length() == 1 ? "1" : (term.length() == 2 && term.charAt(0) == '-' ? "-1" : term.substring(0, term.length() - 1));
        }
        return coefficient;
    }

    public String hasCoefficient(String term) {
        String coefficient;
        if (!EqFeaturePredicate.isArithmeticExpression(term)) {
            return null;
        }
        String hasCoefficient = null;
        if (this.isVarTerm(term) && (coefficient = EqFeaturePredicate.coefficient(term)) != null && !coefficient.equals("1")) {
            hasCoefficient = "T";
        }
        return hasCoefficient;
    }

    public String firstVarTerm(String term) {
        String firstVarTerm;
        block4: {
            if (!EqFeaturePredicate.isArithmeticExpression(term)) {
                return null;
            }
            firstVarTerm = null;
            try {
                AlgebraExp firstVarExp;
                AlgebraExp exp = AlgebraExp.parseExp(term);
                if (exp.isPolynomial() && (firstVarExp = exp.getFirstVarTerm()) != null) {
                    firstVarTerm = firstVarExp.toString();
                }
            }
            catch (ParseException e) {
                if (!trace.getDebugCode("missalgebra")) break block4;
                e.printStackTrace();
            }
        }
        return firstVarTerm;
    }

    public String firstVarTerm_obsolete(String term) {
        String firstVarTerm;
        String string = firstVarTerm = this.hasVarTerm(term) != null ? "" : null;
        if (firstVarTerm != null) {
            ArrayList termTokens = this.tokenizeTerms(term);
            for (int i = 0; i < termTokens.size(); ++i) {
                String theTerm = (String)termTokens.get(i);
                if (this.varTerm(theTerm) == null) continue;
                firstVarTerm = this.trimPlusSignInFront(theTerm);
                break;
            }
        }
        return firstVarTerm;
    }

    public String firstTerm(String term) {
        String firstTerm;
        block4: {
            if (!EqFeaturePredicate.isArithmeticExpression(term)) {
                return null;
            }
            firstTerm = null;
            try {
                AlgebraExp getFirstTerm;
                AlgebraExp exp = AlgebraExp.parseExp(term);
                if (exp.isPolynomial() && (getFirstTerm = exp.getFirstTerm()) != null) {
                    firstTerm = getFirstTerm.toString();
                }
            }
            catch (ParseException e) {
                if (!trace.getDebugCode("missalgebra")) break block4;
                e.printStackTrace();
            }
        }
        return firstTerm;
    }

    public String lastTerm(String term) {
        String lastTerm;
        block4: {
            if (!EqFeaturePredicate.isArithmeticExpression(term)) {
                return null;
            }
            lastTerm = null;
            try {
                AlgebraExp getLastTerm;
                AlgebraExp exp = AlgebraExp.parseExp(term);
                if (exp.isPolynomial() && (getLastTerm = exp.getLastTerm()) != null) {
                    lastTerm = getLastTerm.toString();
                }
            }
            catch (ParseException e) {
                if (!trace.getDebugCode("missalgebra")) break block4;
                e.printStackTrace();
            }
        }
        return lastTerm;
    }

    public String lastTerm_Obsolete(String term) {
        String lastTerm;
        String string = lastTerm = this.polynomial(term) != null ? "" : null;
        if (lastTerm != null) {
            ArrayList termTokens = this.tokenizeTerms(term);
            lastTerm = (String)termTokens.get(termTokens.size() - 1);
            lastTerm = this.trimPlusSignInFront(lastTerm);
        }
        return lastTerm;
    }

    public String lastConstTerm(String term) {
        String lastConstTerm;
        block4: {
            if (!EqFeaturePredicate.isArithmeticExpression(term)) {
                return null;
            }
            lastConstTerm = null;
            try {
                AlgebraExp lastConstExp;
                AlgebraExp exp = AlgebraExp.parseExp(term);
                if (exp.isPolynomial() && (lastConstExp = exp.getLastConstTerm()) != null) {
                    lastConstTerm = lastConstExp.toString();
                }
            }
            catch (ParseException e) {
                if (!trace.getDebugCode("missalgebra")) break block4;
                e.printStackTrace();
            }
        }
        return lastConstTerm;
    }

    public String lastConstTerm_obsolete(String term) {
        String lastConstTerm;
        String string = lastConstTerm = this.hasConstTerm(term) != null ? "" : null;
        if (lastConstTerm != null) {
            ArrayList termTokens = this.tokenizeTerms(term);
            for (int i = termTokens.size(); i > 0; --i) {
                String theTerm = (String)termTokens.get(i - 1);
                if (this.varTerm(theTerm) != null) continue;
                lastConstTerm = this.trimPlusSignInFront(theTerm);
                break;
            }
        }
        return lastConstTerm;
    }

    public String cancelLastConstTerm(String term) {
        if (!EqFeaturePredicate.isArithmeticExpression(term)) {
            return null;
        }
        String cancelLastConstTerm = null;
        String lastConstTerm = this.lastConstTerm(term);
        if (lastConstTerm != null) {
            cancelLastConstTerm = this.addTermBy(term, this.reverseSign(lastConstTerm));
        }
        return cancelLastConstTerm;
    }

    public String varName(String term) {
        if (!EqFeaturePredicate.isArithmeticExpression(term)) {
            return null;
        }
        String name = null;
        for (int i = 0; i < term.length(); ++i) {
            char c = term.charAt(i);
            if (('a' > c || c > 'z') && ('A' > c || c > 'Z')) continue;
            name = "" + c;
            break;
        }
        return name;
    }

    public String isOne(String term) {
        return term.matches("1([.]0+)?") ? "T" : null;
    }

    public String canBeSimplified(String term) {
        if (!EqFeaturePredicate.isArithmeticExpression(term)) {
            return null;
        }
        String canBeSimplified = null;
        String evalTerm = this.evalArithmetic(term);
        if (evalTerm != null && !evalTerm.equals(term)) {
            canBeSimplified = "T";
        }
        return canBeSimplified;
    }

    public String canBeSimplifiedMonomial(String term) {
        if (!this.isMonomial(term)) {
            return null;
        }
        String canBeSimplifiedTerm = null;
        String evalTerm = this.evalArithmetic(term);
        if (evalTerm != null && !evalTerm.equals(term)) {
            canBeSimplifiedTerm = "T";
        }
        return canBeSimplifiedTerm;
    }

    public String canBeSimplifiedPolynomial(String term) {
        if (!this.isPolynomial(term)) {
            return null;
        }
        String canBeSimplifiedPolynomial = null;
        String evalTerm = this.evalArithmetic(term);
        if (evalTerm != null && !evalTerm.equals(term)) {
            canBeSimplifiedPolynomial = "T";
        }
        return canBeSimplifiedPolynomial;
    }

    public String hasVarTerm(String term) {
        String hasVarTerm;
        block4: {
            if (!EqFeaturePredicate.isArithmeticExpression(term)) {
                return null;
            }
            hasVarTerm = null;
            try {
                if (this.hasVarTerm(AlgebraExp.parseExp(term))) {
                    hasVarTerm = "T";
                }
            }
            catch (ParseException e) {
                if (!trace.getDebugCode("missalgebra")) break block4;
                e.printStackTrace();
            }
        }
        return hasVarTerm;
    }

    public String hasVarTerm_obsolete(String term) {
        String hasVarTerm = null;
        if (this.hasVarTerm(this.tokenizeTerms(term))) {
            hasVarTerm = "T";
        }
        return hasVarTerm;
    }

    public String hasConstTerm(String term) {
        if (!EqFeaturePredicate.isArithmeticExpression(term)) {
            return null;
        }
        String hasConstTerm = null;
        if (this.hasConstTerm(this.tokenizeTerms(term))) {
            hasConstTerm = "T";
        }
        return hasConstTerm;
    }

    public String varTerm(String term) {
        if (!EqFeaturePredicate.isArithmeticExpression(term)) {
            return null;
        }
        String returnVal = null;
        if (this.isMonomial(term)) {
            term = term.toUpperCase();
            for (int i = 0; i < term.length(); ++i) {
                char c = term.toUpperCase().charAt(i);
                if ('A' > c || c > 'Z') continue;
                returnVal = "T";
                break;
            }
        }
        return returnVal;
    }

    public String monomial(String term) {
        if (!EqFeaturePredicate.isArithmeticExpression(term)) {
            return null;
        }
        return this.polynomial(term) == null ? "T" : null;
    }

    public String polynomial(String term) {
        if (!EqFeaturePredicate.isArithmeticExpression(term)) {
            return null;
        }
        ArrayList termTokens = this.tokenizeTerms(term);
        return termTokens.size() == 1 ? null : "T";
    }

    public String homogeneous(String term) {
        if (!EqFeaturePredicate.isArithmeticExpression(term)) {
            return null;
        }
        String homogeneous = null;
        ArrayList termTokens = this.tokenizeTerms(term);
        String firstTerm = null;
        firstTerm = (String)termTokens.get(0);
        termTokens.remove(0);
        if (this.varTerm(firstTerm) != null) {
            if (!this.hasConstTerm(termTokens)) {
                homogeneous = "T";
            }
        } else if (!this.hasVarTerm(termTokens)) {
            homogeneous = "T";
        }
        return homogeneous;
    }

    public String isFractionTerm(String term) {
        AlgebraExp termParsed;
        block3: {
            if (!EqFeaturePredicate.isArithmeticExpression(term)) {
                return null;
            }
            termParsed = null;
            try {
                termParsed = AlgebraExp.parseExp(term);
            }
            catch (ParseException e) {
                if (!trace.getDebugCode("missalgebra")) break block3;
                trace.out("missalgebra", "fractionTerm(" + term + ")");
                e.printStackTrace();
            }
        }
        return termParsed.isFraction() ? "T" : null;
    }

    public String ripCoefficient(String term) {
        String ripCoefficient;
        block6: {
            if (!EqFeaturePredicate.isArithmeticExpression(term)) {
                return null;
            }
            ripCoefficient = null;
            AlgebraExp exp = null;
            try {
                exp = AlgebraExp.parseExp(term);
                if (!exp.isTerm()) {
                    return null;
                }
                if (exp.isFraction() && (exp.getDenominator().isPolynomial() || exp.getNumerator().isPolynomial())) {
                    return null;
                }
                if (exp.getVarName() != null && !exp.getVarName().equals("")) {
                    ripCoefficient = exp.getVarName();
                }
            }
            catch (ParseException e) {
                if (!trace.getDebugCode("missalgebra")) break block6;
                e.printStackTrace();
            }
        }
        return ripCoefficient;
    }

    public String ripCoefficient_obsolete(String term) {
        String val = this.monomial(term) != null ? this.varName(term) : null;
        return val;
    }

    public String removeFirstVarTerm(String term) {
        String removeFirstVarTerm;
        block5: {
            if (!EqFeaturePredicate.isArithmeticExpression(term)) {
                return null;
            }
            removeFirstVarTerm = null;
            try {
                AlgebraExp exp = AlgebraExp.parseExp(term);
                if (exp.isTerm() && exp.isVarTerm()) {
                    return "0";
                }
                AlgebraExp newExp = exp.removeFirstVarTerm();
                if (newExp != null) {
                    removeFirstVarTerm = newExp.toString();
                }
            }
            catch (ParseException e) {
                if (!trace.getDebugCode("missalgebra")) break block5;
                e.printStackTrace();
            }
        }
        return removeFirstVarTerm;
    }

    public String removeFirstVarTerm_obsolete(String term) {
        String result;
        String string = result = this.polynomial(term) != null ? "" : null;
        if (result != null) {
            boolean termRemoved = false;
            ArrayList termTokens = this.tokenizeTerms(term);
            for (int i = 0; i < termTokens.size(); ++i) {
                String theTerm = (String)termTokens.get(i);
                if (!termRemoved && this.varTerm(theTerm) != null) {
                    termRemoved = true;
                    continue;
                }
                result = result + theTerm;
            }
        }
        if (result != null) {
            result = this.trimPlusSignInFront(result);
        }
        return result;
    }

    public String removeLastTerm(String term) {
        String removeLastTerm;
        block4: {
            if (!EqFeaturePredicate.isArithmeticExpression(term)) {
                return null;
            }
            removeLastTerm = null;
            try {
                AlgebraExp exp = AlgebraExp.parseExp(term);
                AlgebraExp newExp = exp.removeLastTerm();
                if (newExp != null) {
                    removeLastTerm = newExp.toString();
                }
            }
            catch (ParseException e) {
                if (!trace.getDebugCode("missalgebra")) break block4;
                e.printStackTrace();
            }
        }
        return removeLastTerm;
    }

    public String removeLastTerm_obsolete(String term) {
        String removeLastTerm = null;
        if (this.polynomial(term) != null) {
            int indexMinus;
            int indexPlus = term.lastIndexOf(43);
            int theIndex = indexPlus < (indexMinus = term.lastIndexOf(45)) ? indexMinus : indexPlus;
            removeLastTerm = term.substring(0, theIndex);
        }
        return removeLastTerm;
    }

    public String removeLastConstTerm(String term) {
        String removeLastConstTerm;
        block5: {
            if (!EqFeaturePredicate.isArithmeticExpression(term)) {
                return null;
            }
            removeLastConstTerm = null;
            try {
                AlgebraExp exp = AlgebraExp.parseExp(term);
                if (exp.isTerm() && exp.isConstTerm()) {
                    return "0";
                }
                AlgebraExp newExp = exp.removeLastConstTerm();
                if (newExp != null) {
                    removeLastConstTerm = newExp.toString();
                }
            }
            catch (ParseException e) {
                if (!trace.getDebugCode("missalgebra")) break block5;
                e.printStackTrace();
            }
        }
        return removeLastConstTerm;
    }

    public String removeLastConstTerm_Obsolete(String term) {
        String result;
        String string = result = this.polynomial(term) != null ? "" : null;
        if (result != null) {
            boolean termRemoved = false;
            ArrayList termTokens = this.tokenizeTerms(term);
            for (int i = termTokens.size(); i > 0; --i) {
                String theTerm = (String)termTokens.get(i - 1);
                if (!termRemoved && this.varTerm(theTerm) == null) {
                    termRemoved = true;
                    continue;
                }
                result = theTerm + result;
            }
        }
        if (result != null) {
            result = this.trimPlusSignInFront(result);
        }
        return result;
    }

    public String reverseSign(String term) {
        String reverseSign;
        block14: {
            if (!EqFeaturePredicate.isArithmeticExpression(term)) {
                return null;
            }
            reverseSign = null;
            try {
                AlgebraExp exp = AlgebraExp.parseExp(term);
                if (exp.isMultiplication()) {
                    return this.mulTermBy(this.reverseSign(exp.getFirstTerm().toString()), exp.getSecondTerm().toString());
                }
                if (exp.isTerm()) {
                    if (exp.isFraction()) {
                        String t1 = this.reverseSign(exp.getFirstTerm().toString());
                        String t2 = exp.getSecondTerm().toString();
                        if (this.isVarTerm(t2)) {
                            t2 = "(" + t2 + ")";
                        }
                        return t1 + "/" + t2;
                    }
                    String c = exp.isVarTerm() ? exp.getCoefficient() : term;
                    try {
                        String rc = exp.isDecimal() ? String.valueOf(Double.parseDouble(c) * -1.0) : "" + Integer.parseInt(c) * -1;
                        String v = exp.getVarName();
                        if (!v.equals("")) {
                            if (rc.equals("1")) {
                                rc = "";
                            } else if (rc.equals("-1")) {
                                rc = "-";
                            }
                        }
                        reverseSign = rc + v;
                    }
                    catch (Exception e) {
                        trace.out("eqfp", "reverseSign(" + term + ")");
                    }
                    break block14;
                }
                if (term.charAt(0) == '-' && (term = term.substring(1)).charAt(0) == '(') {
                    term = term.substring(0, term.length());
                }
                term = term.charAt(0) == '(' ? "-" + term : "-(" + term + ")";
                return term;
            }
            catch (ParseException e) {
                if (!trace.getDebugCode("missalgebra")) break block14;
                e.printStackTrace();
            }
        }
        return reverseSign;
    }

    public String factorOutCommonTerm(String term) {
        try {
            AlgebraExp exp = AlgebraExp.parseExp(term);
            AlgebraExp factor = exp.getFactor();
            if (factor == null) {
                return null;
            }
            AlgebraExp innerExp = exp.multTerm(factor.Invert());
            return factor + "(" + innerExp + ")";
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String distributeFactor(String term) {
        AlgebraExp exp;
        if (!term.matches(".*[0-9]+[*]?[(].+[)].*")) {
            return null;
        }
        int leftParenWithMulIndex = term.indexOf("*(");
        int leftParenIndex = term.indexOf("(");
        int rightParenIndex = term.indexOf(")");
        int factorStartIndex = this.findFirstDistributableFactorIndex(term);
        int factorEndIndex = leftParenWithMulIndex == -1 ? leftParenIndex - 1 : leftParenWithMulIndex - 1;
        String factor = term.substring(factorStartIndex, factorEndIndex + 1);
        String expression = term.substring(leftParenIndex + 1, rightParenIndex);
        try {
            exp = AlgebraExp.parseExp(expression);
            exp = exp.multTerm(AlgebraExp.parseExp(factor));
        }
        catch (ParseException e) {
            return null;
        }
        String before = "";
        String after = "";
        if (factorStartIndex != 0) {
            before = term.substring(0, factorStartIndex);
        }
        if (rightParenIndex != term.length() - 1) {
            after = term.substring(rightParenIndex + 1);
        }
        return before + exp + after;
    }

    public String inverseTerm(String term) {
        String inverseTerm;
        block5: {
            if (!EqFeaturePredicate.isArithmeticExpression(term)) {
                return null;
            }
            if (this.isPolynomial(term)) {
                return null;
            }
            inverseTerm = null;
            try {
                String evalTerm = this.evalArithmetic(term);
                if (evalTerm != null && !evalTerm.equals("0")) {
                    AlgebraExp exp = AlgebraExp.parseExp(term);
                    AlgebraExpPoly newExp = null;
                    newExp = exp.isFraction() ? new AlgebraExpPoly("/", exp.getDenominator(), exp.getNumerator()) : new AlgebraExpPoly("/", AlgebraExp.parseExp("1"), exp);
                    inverseTerm = ((Object)newExp).toString();
                }
            }
            catch (ParseException e) {
                if (!trace.getDebugCode("missalgebra")) break block5;
                trace.out("missalgebra", "inverseTerm(" + term + ")...");
                e.printStackTrace();
            }
        }
        return inverseTerm;
    }

    public String inverseTerm_obsolete_II(String term) {
        String inverseTerm = null;
        if (!term.equals("0")) {
            String numerator;
            String denominator;
            block6: {
                try {
                    AlgebraExp exp = AlgebraExp.parseExp(term);
                    AlgebraExp newExp = exp.inverseTerm();
                    if (newExp != null) {
                        inverseTerm = newExp.toString();
                    }
                }
                catch (ParseException e) {
                    if (!trace.getDebugCode("missalgebra")) break block6;
                    e.printStackTrace();
                }
            }
            if (inverseTerm != null && (denominator = this.denominator(inverseTerm)) != null && (numerator = this.numerator(inverseTerm)) != null) {
                inverseTerm = this.divTermBy(numerator, denominator);
            }
        } else {
            inverseTerm = term;
        }
        return inverseTerm;
    }

    public String inverseTerm_obsolete(String term) {
        String inverseTerm = null;
        if (term.equals("0")) {
            inverseTerm = term;
        } else if (!term.equals("") && this.isMonomial(term)) {
            switch (term.charAt(0)) {
                case '-': {
                    inverseTerm = term.substring(1, term.length());
                    break;
                }
                case '+': {
                    inverseTerm = "-" + term.substring(1, term.length());
                    break;
                }
                default: {
                    inverseTerm = "-" + term;
                }
            }
        }
        return inverseTerm;
    }

    public String divTermBy(String t1, String t2) {
        if (!EqFeaturePredicate.isArithmeticExpression(t1) || !EqFeaturePredicate.isArithmeticExpression(t2)) {
            return null;
        }
        if (this.hasVarTermP(t1) && this.hasVarTermP(t2)) {
            return null;
        }
        String divTermBy = null;
        if (!t2.equals("0")) {
            if (t1.indexOf(45) != -1 || t1.indexOf(43) != -1 || t1.indexOf(47) != -1) {
                t1 = "(" + t1 + ")";
            }
            if (this.isVarTerm(t2) && this.hasCoefficient(t2) != null || this.isPolynomial(t2) || t2.indexOf(45) != -1) {
                t2 = "(" + t2 + ")";
            }
            divTermBy = t1 + "/" + t2;
        }
        return divTermBy;
    }

    public String addTermBy(String t1, String t2) {
        String addTermBy;
        block3: {
            if (!EqFeaturePredicate.isArithmeticExpression(t1) || !EqFeaturePredicate.isArithmeticExpression(t2)) {
                return null;
            }
            addTermBy = null;
            try {
                AlgebraExp exp2 = AlgebraExp.parseExp(t2);
                addTermBy = t2.charAt(0) == '-' ? (exp2.isTerm() || exp2.isAddition() ? t1 + t2 : t1 + "+(" + t2 + ")") : t1 + "+" + t2;
            }
            catch (ParseException e) {
                if (!trace.getDebugCode("missalgebra")) break block3;
                e.printStackTrace();
            }
        }
        return addTermBy;
    }

    public String mulTermBy(String t1, String t2) {
        if (!EqFeaturePredicate.isArithmeticExpression(t1) || !EqFeaturePredicate.isArithmeticExpression(t2)) {
            return null;
        }
        if (this.hasVarTermP(t1) && this.hasVarTermP(t2)) {
            return null;
        }
        String mulTermBy = null;
        if (t1.indexOf(45) != -1 || t1.indexOf(43) != -1 || t1.indexOf(47) != -1) {
            t1 = "(" + t1 + ")";
        }
        if (t2.indexOf(45) != -1 || t2.indexOf(43) != -1 || t2.indexOf(42) != -1 || t2.indexOf(47) != -1) {
            t2 = "(" + t2 + ")";
        }
        mulTermBy = t1 + "*" + t2;
        return mulTermBy;
    }

    public String subTermBy(String t1, String t2) {
        if (!EqFeaturePredicate.isArithmeticExpression(t1) || !EqFeaturePredicate.isArithmeticExpression(t2)) {
            return null;
        }
        if (t2.charAt(0) == '-') {
            t2 = "(" + t2 + ")";
        }
        return t1 + "-" + t2;
    }

    public String subTerm(String expString1, String expString2) {
        String subTerm = null;
        if (EqFeaturePredicate.isArithmeticExpression(expString1) && EqFeaturePredicate.isArithmeticExpression(expString2)) {
            String negExpString2 = this.reverseSign(expString2);
            subTerm = this.addTerm(expString1, negExpString2);
        }
        return subTerm;
    }

    public String modTen(String n) {
        if (!EqFeaturePredicate.isArithmeticExpression(n)) {
            return null;
        }
        String modTen = null;
        try {
            int nInt = Integer.parseInt(n);
            modTen = "" + nInt % 10;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return modTen;
    }

    public String divTen(String n) {
        if (!EqFeaturePredicate.isArithmeticExpression(n)) {
            return null;
        }
        String divTen = null;
        try {
            divTen = n.indexOf(".") != -1 ? String.valueOf(Double.parseDouble(n) / 10.0) : "" + Integer.parseInt(n) / 10;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return divTen;
    }

    public String divTerm(String t1, String t2) {
        String divTerm;
        block7: {
            if (!EqFeaturePredicate.isArithmeticExpression(t1) || !EqFeaturePredicate.isArithmeticExpression(t2)) {
                return null;
            }
            divTerm = null;
            if (t2.equals("1")) {
                divTerm = t1;
            } else if (!t2.equals("0")) {
                try {
                    AlgebraExp exp1 = AlgebraExp.parseExp(t1);
                    AlgebraExp exp2 = AlgebraExp.parseExp(t2);
                    AlgebraExp exp = exp1.divTerm(exp2);
                    if (exp != null) {
                        divTerm = exp.toString();
                    }
                }
                catch (ParseException e) {
                    if (!trace.getDebugCode("missalgebra")) break block7;
                    e.printStackTrace();
                }
            }
        }
        return divTerm;
    }

    public String mulTerm(String t1, String t2) {
        String mulTerm;
        block5: {
            if (!EqFeaturePredicate.isArithmeticExpression(t1) || !EqFeaturePredicate.isArithmeticExpression(t2)) {
                return null;
            }
            if (this.hasVarTermP(t1) && this.hasVarTermP(t2)) {
                return null;
            }
            mulTerm = null;
            try {
                AlgebraExp exp1 = AlgebraExp.parseExp(t1);
                AlgebraExp exp2 = AlgebraExp.parseExp(t2);
                AlgebraExp exp = exp1.multTerm(exp2);
                if (exp != null) {
                    mulTerm = exp.toString();
                }
            }
            catch (ParseException e) {
                if (!trace.getDebugCode("missalgebra")) break block5;
                e.printStackTrace();
            }
        }
        return mulTerm;
    }

    public String divTerm_obsolete(String t1, String t2) {
        String quatient = null;
        if (this.isPolynomial(t1) || this.isPolynomial(t2)) {
            return null;
        }
        try {
            if (this.isVarTerm(t2) || !MathLib.isFraction((String)t2) && Integer.parseInt(t2) == 0) {
                return null;
            }
        }
        catch (NumberFormatException e) {
            if (trace.getDebugCode("missalgebra")) {
                e.printStackTrace();
            }
            return null;
        }
        if (this.isVarTerm(t1)) {
            if (this.isVarTerm(t2)) {
                quatient = this.divTerm(EqFeaturePredicate.coefficient(t1), EqFeaturePredicate.coefficient(t2));
            } else {
                String coefficient = this.divTerm(EqFeaturePredicate.coefficient(t1), t2);
                if (coefficient.equals("1")) {
                    coefficient = "";
                }
                quatient = coefficient + this.varName(t1);
            }
        } else {
            quatient = MathLib.div((String)t1, (String)t2);
        }
        return quatient;
    }

    public String addTerm(String term1, String term2) {
        String addTerm;
        block7: {
            if (!EqFeaturePredicate.isArithmeticExpression(term1) || !EqFeaturePredicate.isArithmeticExpression(term2)) {
                return null;
            }
            addTerm = null;
            try {
                AlgebraExp exp1 = AlgebraExp.parseExp(term1);
                AlgebraExp exp2 = AlgebraExp.parseExp(term2);
                AlgebraExp exp = null;
                if (exp1.isTerm() && exp2.isTerm() && (this.isVarTerm(term1) && this.isVarTerm(term2) || !this.isVarTerm(term1) && !this.isVarTerm(term2))) {
                    if (exp1 != null) {
                        exp = exp1.addTerm(exp2);
                    }
                } else {
                    exp = new AlgebraExpPoly("+", exp1, exp2).evalArithmetic();
                }
                if (exp != null) {
                    addTerm = exp.toString();
                }
            }
            catch (ParseException e) {
                trace.out("missalgebra", "addTerm(" + term1 + "," + term2 + ")...");
                if (!trace.getDebugCode("missalgebra")) break block7;
                e.printStackTrace();
            }
        }
        return addTerm;
    }

    public String addTerm_obsolete(String term1, String term2) {
        String addTerm = null;
        if (!term1.equals("") && !term2.equals("")) {
            addTerm = term1 + (term2.charAt(0) != '+' && term2.charAt(0) != '-' ? "+" : "") + term2;
        }
        return addTerm;
    }

    public String evalArithmetic(String term) {
        AlgebraExp algebraExp;
        block3: {
            if (!EqFeaturePredicate.isArithmeticExpression(term)) {
                return null;
            }
            algebraExp = null;
            try {
                algebraExp = AlgebraExp.parseExp(term);
                algebraExp = algebraExp.evalArithmetic();
            }
            catch (ParseException e) {
                if (!trace.getDebugCode("missalgebra")) break block3;
                e.printStackTrace();
            }
        }
        return algebraExp != null ? algebraExp.toString() : null;
    }

    public String evalArithmetic_Old(String term) {
        String doAlgebra;
        String string = doAlgebra = this.isPolynomial(term) && this.isHomogeneous(term) ? "" : null;
        if (doAlgebra != null) {
            String varName = "";
            String value = "0";
            ArrayList termTokens = this.tokenizeTerms(term);
            for (int i = 0; i < termTokens.size(); ++i) {
                try {
                    String item = (String)termTokens.get(i);
                    if (item.charAt(0) == '+') {
                        item = item.substring(1, item.length());
                    }
                    if (this.isVarTerm(item)) {
                        varName = this.varName(item);
                        item = EqFeaturePredicate.coefficient(item);
                    }
                    value = MathLib.add((String)value, (String)item);
                    continue;
                }
                catch (NumberFormatException e) {
                    if (!trace.getDebugCode("missalgebra")) continue;
                    trace.out("missalgebra", "evalArithmetic(" + term + ")");
                    trace.out("missalgebra", ">>> " + (String)termTokens.get(i));
                    trace.out("missalgebra", this.varTerm((String)termTokens.get(i)));
                    e.printStackTrace();
                }
            }
            doAlgebra = (varName != "" && value.equals("1") ? "" : value) + (value.equals("0") ? "" : varName);
        }
        return doAlgebra;
    }

    public String numerator(String term) {
        String numerator;
        block4: {
            if (!EqFeaturePredicate.isArithmeticExpression(term)) {
                return null;
            }
            numerator = null;
            try {
                AlgebraExp exp = AlgebraExp.parseExp(term);
                if (exp.isFraction()) {
                    numerator = exp.getNumerator().toString();
                }
            }
            catch (ParseException e) {
                if (!trace.getDebugCode("missalgebra")) break block4;
                e.printStackTrace();
            }
        }
        return numerator;
    }

    public String denominator(String term) {
        String denominator;
        block4: {
            if (!EqFeaturePredicate.isArithmeticExpression(term)) {
                return null;
            }
            denominator = null;
            try {
                AlgebraExp exp = AlgebraExp.parseExp(term);
                if (exp != null && exp.isFraction()) {
                    denominator = exp.getDenominator().toString();
                }
            }
            catch (ParseException e) {
                if (!trace.getDebugCode("missalgebra")) break block4;
                e.printStackTrace();
            }
        }
        return denominator;
    }

    public String cancelDenominator(String term) {
        if (!EqFeaturePredicate.isArithmeticExpression(term)) {
            return null;
        }
        String cancelDenominator = null;
        if (this.isFractionTerm(term) != null) {
            String denominator = this.denominator(term);
            cancelDenominator = this.mulTermBy(term, denominator);
        }
        return cancelDenominator;
    }

    public String cancelCoefficient(String term) {
        if (!EqFeaturePredicate.isArithmeticExpression(term)) {
            return null;
        }
        String cancelCoefficient = null;
        if (this.hasCoefficient(term) != null) {
            String coefficient = EqFeaturePredicate.coefficient(term);
            cancelCoefficient = this.divTermBy(term, coefficient);
        }
        return cancelCoefficient;
    }

    public String sameRow(String fact1, String fact2) {
        System.out.println("sameRow(" + fact1 + "," + fact2 + ")");
        return null;
    }

    public String consecutiveRow(String fact1, String fact2) {
        System.out.println("consecutiveRow(" + fact1 + "," + fact2 + ")");
        return null;
    }

    public String sameColumn(String fact1, String fact2) {
        System.out.println("sameColumn(" + fact1 + "," + fact2 + ")");
        return null;
    }

    public String consecutiveColumn(String fact1, String fact2) {
        System.out.println("consecutiveColumn(" + fact1 + "," + fact2 + ")");
        return null;
    }

    private Vector getTopLevelQuantities(String term) {
        while (term.charAt(0) == '(') {
            term = this.stripOuterParens(term);
        }
        char[] array = term.toCharArray();
        int unmatchedParens = 0;
        Vector<String> quanities = new Vector<String>();
        int startIndex = -1;
        for (int termIndex = 0; termIndex < term.length(); ++termIndex) {
            if (array[termIndex] == '(') {
                if (unmatchedParens == 0) {
                    startIndex = termIndex;
                }
                ++unmatchedParens;
            }
            if (array[termIndex] != ')' || --unmatchedParens != 0) continue;
            quanities.add(term.substring(startIndex, termIndex + 1));
        }
        if (quanities.isEmpty()) {
            return null;
        }
        return quanities;
    }

    private String stripOuterParens(String term) {
        int leftParenIndex = term.indexOf("(");
        if (leftParenIndex == -1) {
            return term;
        }
        return term.substring(leftParenIndex + 1, term.length() - 1);
    }

    private boolean isVarTerm(String term) {
        return this.varTerm(term) != null;
    }

    private boolean isHomogeneous(String term) {
        return this.homogeneous(term) != null;
    }

    public boolean isPolynomial(String term) {
        return this.polynomial(term) != null;
    }

    private boolean isMonomial(String term) {
        return this.monomial(term) != null;
    }

    private boolean hasConstTerm(ArrayList terms) {
        return !this.allVarTerms(terms);
    }

    private boolean hasVarTerm(AlgebraExp exp) {
        if (exp.isTerm()) {
            return this.isVarTerm(exp.toString());
        }
        return this.hasVarTerm(exp.getFirstTerm()) || this.hasVarTerm(exp.getSecondTerm());
    }

    private boolean hasVarTerm(ArrayList terms) {
        return !this.allConstTerms(terms);
    }

    private boolean hasVarTermP(String term) {
        boolean hasVarTermP;
        block2: {
            hasVarTermP = false;
            try {
                hasVarTermP = this.hasVarTerm(AlgebraExp.parseExp(term));
            }
            catch (ParseException e) {
                if (!trace.getDebugCode("missalgebra")) break block2;
                e.printStackTrace();
            }
        }
        return hasVarTermP;
    }

    private boolean allVarTerms(ArrayList terms) {
        boolean allVarTerms = true;
        for (int i = 0; i < terms.size(); ++i) {
            if (this.varTerm((String)terms.get(i)) != null) continue;
            allVarTerms = false;
            break;
        }
        return allVarTerms;
    }

    private boolean allConstTerms(ArrayList terms) {
        boolean allConstTerms = true;
        for (int i = 0; i < terms.size(); ++i) {
            if (this.varTerm((String)terms.get(i)) == null) continue;
            allConstTerms = false;
            break;
        }
        return allConstTerms;
    }

    private int findFirstDistributableFactorIndex(String term) {
        int withMulIndex = term.indexOf("*(");
        int leftParenIndex = term.indexOf("(");
        int factorEndIndex = withMulIndex != -1 ? withMulIndex - 1 : leftParenIndex - 1;
        char[] temp = term.toCharArray();
        int factorStartIndex = factorEndIndex;
        if (factorEndIndex != 0) {
            int index = factorEndIndex;
            char curChar = temp[index];
            while (index > 0 && ('0' <= curChar && curChar <= '9' || curChar == '/')) {
                char prev;
                if ((curChar = temp[--index]) != '/' || '0' <= (prev = temp[index - 1]) && '9' >= prev) continue;
                ++index;
                break;
            }
            factorStartIndex = index;
        }
        return factorStartIndex;
    }

    private String trimPlusSignInFront(String term) {
        if (term.charAt(0) == '+') {
            term = term.substring(1);
        }
        return term;
    }

    ArrayList tokenizeTerms(String term) {
        AlgebraExp exp;
        block2: {
            exp = null;
            try {
                exp = AlgebraExp.parseExp(term);
            }
            catch (ParseException e) {
                if (!trace.getDebugCode("missalgebra")) break block2;
                e.printStackTrace();
            }
        }
        return this.tokenizeTerms(exp);
    }

    ArrayList tokenizeTerms(AlgebraExp exp) {
        if (exp.isPolynomial() && (exp.getOp().equals("+") || exp.getOp().equals("-"))) {
            return this.append(this.tokenizeTerms(exp.getFirstTerm()), this.tokenizeTerms(exp.getSecondTerm()));
        }
        ArrayList<String> token = new ArrayList<String>();
        token.add(exp.toString());
        return token;
    }

    ArrayList append(ArrayList list1, ArrayList list2) {
        ArrayList newList = new ArrayList(list1);
        for (int i = 0; i < list2.size(); ++i) {
            newList.add(list2.get(i));
        }
        return newList;
    }

    ArrayList tokenizeTerms_obsolete(String term) {
        ArrayList<String> tokenizedTermes = new ArrayList<String>();
        StringTokenizer termTokens = new StringTokenizer(term, "+-", true);
        while (termTokens.hasMoreTokens()) {
            String token = termTokens.nextToken();
            if (token.equals("+") || token.equals("-")) {
                token = token + termTokens.nextToken();
            }
            tokenizedTermes.add(token);
        }
        return tokenizedTermes;
    }
}

