/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.userDef.topological.table;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.WMEConstraintPredicate;
import java.util.Iterator;
import java.util.Vector;
import jess.Context;
import jess.Fact;
import jess.JessException;
import jess.Rete;
import jess.Value;
import jess.ValueVector;

public abstract class TableConstraint
extends WMEConstraintPredicate {
    final String CELL_TYPE = "MAIN::cell";
    final String COLUMN_TYPE = "MAIN::column";
    final String COLUMN_INDEX_SLOT = "column-number";
    final String ROW_INDEX_SLOT = "row-number";
    final String TABLE_INDEX_SLOT = "table-number";
    final String TABLE_TYPE = "MAIN::table";
    final String COLUMN_LIST_NAME = "columns";
    final String CELL_LIST_NAME = "cells";

    public String isConsecutiveTextField(Fact f1, Fact f2) throws JessException {
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "f1.getName(): " + f1.getName() + "  f2.getName(): " + f2.getName());
        }
        if (f1.toString().contains("commTextField1") && f2.toString().contains("commTextField2")) {
            return "T";
        }
        if (f1.toString().contains("commTextField2") && f2.toString().contains("commTextField3")) {
            return "T";
        }
        if (f1.toString().contains("commTextField3") && f2.toString().contains("commTextField4")) {
            return "T";
        }
        if (f1.toString().contains("commTextField4") && f2.toString().contains("commTextField5")) {
            return "T";
        }
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "isConsecutiveTextField returning null");
        }
        return null;
    }

    protected String sameColumn(Fact f1, Fact f2, Rete rete) throws JessException {
        if (this.isCell(f1) && this.isCell(f2) && this.getColumnPosition(rete, f1) == this.getColumnPosition(rete, f2)) {
            return "T";
        }
        return null;
    }

    protected String consecutiveColumn(Fact f1, Fact f2, Rete rete) throws JessException {
        if (this.isCell(f1) && this.isCell(f2) && this.getColumnPosition(rete, f1) + 1 == this.getColumnPosition(rete, f2)) {
            return "T";
        }
        return null;
    }

    protected String sameRow(Fact f1, Fact f2, Rete rete) throws JessException {
        if (this.isCell(f1) && this.isCell(f2) && this.getRowPosition(rete, f1) == this.getRowPosition(rete, f2)) {
            return "T";
        }
        return null;
    }

    protected String sameTable(Fact f1, Fact f2, Rete rete) throws JessException {
        if (this.isCell(f1) && this.isCell(f2)) {
            Vector tables = this.findAllTables(rete);
            for (Fact curTable : tables) {
                if (!this.isInTable(f1, curTable, rete) || !this.isInTable(f2, curTable, rete)) continue;
                return "T";
            }
        }
        return null;
    }

    protected String consecutiveRow(Fact f1, Fact f2, Rete rete) throws JessException {
        if (this.isCell(f1) && this.isCell(f2) && this.getRowPosition(rete, f1) + 1 == this.getRowPosition(rete, f2)) {
            return "T";
        }
        return null;
    }

    protected String consecutiveTable(Fact f1, Fact f2, Rete rete) throws JessException {
        if (this.isCell(f1) && this.hasTableNumber(f1) && this.isCell(f2) && this.hasTableNumber(f2)) {
            if (this.getTablePosition(rete, f1) + 1 == this.getTablePosition(rete, f2)) {
                trace.out(5, "Reurning true!");
                return "T";
            }
            trace.out(5, "Tables not consecutive: " + this.getTablePosition(rete, f1) + " " + this.getTablePosition(rete, f2) + "\n");
        } else if (trace.getDebugCode("rr")) {
            trace.out(5, "One arg not a table-numbered cell" + f1 + " or " + f2 + "\n");
        }
        return null;
    }

    protected boolean isCell(Fact fact) {
        return fact.getName().equals("MAIN::cell");
    }

    private int getColumnPosition(Rete rete, Fact fact) throws JessException {
        Value position = fact.getSlotValue("column-number");
        Context c = rete.getGlobalContext();
        return position.intValue(c);
    }

    protected int getRowPosition(Rete rete, Fact fact) throws JessException {
        return fact.getSlotValue("row-number").intValue(rete.getGlobalContext());
    }

    private int getTablePosition(Rete rete, Fact fact) throws JessException {
        return fact.getSlotValue("table-number").intValue(rete.getGlobalContext());
    }

    protected boolean isTable(Fact fact) {
        return fact.getName().equals("MAIN::table");
    }

    protected boolean hasTableNumber(Fact fact) {
        return fact.getDeftemplate().getSlotIndex("table-number") > -1;
    }

    protected boolean sameCell(Fact f1, Fact f2) {
        if (this.isCell(f1) && this.isCell(f2)) {
            return f1.getFactId() == f2.getFactId();
        }
        return false;
    }

    protected boolean isInTable(Fact cellFact, Fact tableFact, Rete rete) throws JessException {
        Value columnValue;
        if (this.isCell(cellFact) && this.isTable(tableFact) && (columnValue = tableFact.getSlotValue("columns")) != null) {
            ValueVector columns = columnValue.listValue(rete.getGlobalContext());
            for (int colnum = 0; colnum < columns.size(); ++colnum) {
                Fact curColumn = columns.get(colnum).factValue(rete.getGlobalContext());
                Value cellValue = curColumn.getSlotValue("cells");
                if (cellValue == null) continue;
                ValueVector cells = cellValue.listValue(rete.getGlobalContext());
                for (int cellnum = 0; cellnum < cells.size(); ++cellnum) {
                    Fact curCell = cells.get(cellnum).factValue(rete.getGlobalContext());
                    if (!this.sameCell(cellFact, curCell)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected Vector findAllTables(Rete rete) {
        Vector<Fact> v = new Vector<Fact>();
        Iterator iter = rete.listFacts();
        while (iter.hasNext()) {
            Fact curFact = (Fact)iter.next();
            if (!this.isTable(curFact)) continue;
            v.add(curFact);
        }
        return v;
    }
}

